package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SyntaxToken(
    tokenId: Optional[Integer] = Optional.Absent,
    text: Optional[String] = Optional.Absent,
    beginOffset: Optional[Integer] = Optional.Absent,
    endOffset: Optional[Integer] = Optional.Absent,
    partOfSpeech: Optional[zio.aws.comprehend.model.PartOfSpeechTag] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.SyntaxToken = {
    import SyntaxToken.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.SyntaxToken
      .builder()
      .optionallyWith(tokenId.map(value => value: java.lang.Integer))(_.tokenId)
      .optionallyWith(text.map(value => value: java.lang.String))(_.text)
      .optionallyWith(beginOffset.map(value => value: java.lang.Integer))(
        _.beginOffset
      )
      .optionallyWith(endOffset.map(value => value: java.lang.Integer))(
        _.endOffset
      )
      .optionallyWith(partOfSpeech.map(value => value.buildAwsValue()))(
        _.partOfSpeech
      )
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.SyntaxToken.ReadOnly =
    zio.aws.comprehend.model.SyntaxToken.wrap(buildAwsValue())
}
object SyntaxToken {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.SyntaxToken
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.SyntaxToken =
      zio.aws.comprehend.model.SyntaxToken(
        tokenId.map(value => value),
        text.map(value => value),
        beginOffset.map(value => value),
        endOffset.map(value => value),
        partOfSpeech.map(value => value.asEditable)
      )
    def tokenId: Optional[Integer]
    def text: Optional[String]
    def beginOffset: Optional[Integer]
    def endOffset: Optional[Integer]
    def partOfSpeech
        : Optional[zio.aws.comprehend.model.PartOfSpeechTag.ReadOnly]
    def getTokenId: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("tokenId", tokenId)
    def getText: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("text", text)
    def getBeginOffset: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("beginOffset", beginOffset)
    def getEndOffset: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("endOffset", endOffset)
    def getPartOfSpeech: ZIO[
      Any,
      AwsError,
      zio.aws.comprehend.model.PartOfSpeechTag.ReadOnly
    ] = AwsError.unwrapOptionField("partOfSpeech", partOfSpeech)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.SyntaxToken
  ) extends zio.aws.comprehend.model.SyntaxToken.ReadOnly {
    override val tokenId: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.tokenId())
      .map(value => value: Integer)
    override val text: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.text())
      .map(value => value: String)
    override val beginOffset: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.beginOffset())
      .map(value => value: Integer)
    override val endOffset: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.endOffset())
      .map(value => value: Integer)
    override val partOfSpeech
        : Optional[zio.aws.comprehend.model.PartOfSpeechTag.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.partOfSpeech())
        .map(value => zio.aws.comprehend.model.PartOfSpeechTag.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.SyntaxToken
  ): zio.aws.comprehend.model.SyntaxToken.ReadOnly = new Wrapper(impl)
}
