package zio.aws.comprehend.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.comprehend.model.primitives.{
  ComprehendFlywheelArn,
  IamRoleArn,
  AnyLengthString,
  Timestamp,
  EntityRecognizerArn,
  KmsKeyId,
  VersionName
}
import scala.jdk.CollectionConverters.*
final case class EntityRecognizerProperties(
    entityRecognizerArn: Optional[EntityRecognizerArn] = Optional.Absent,
    languageCode: Optional[zio.aws.comprehend.model.LanguageCode] =
      Optional.Absent,
    status: Optional[zio.aws.comprehend.model.ModelStatus] = Optional.Absent,
    message: Optional[AnyLengthString] = Optional.Absent,
    submitTime: Optional[Timestamp] = Optional.Absent,
    endTime: Optional[Timestamp] = Optional.Absent,
    trainingStartTime: Optional[Timestamp] = Optional.Absent,
    trainingEndTime: Optional[Timestamp] = Optional.Absent,
    inputDataConfig: Optional[
      zio.aws.comprehend.model.EntityRecognizerInputDataConfig
    ] = Optional.Absent,
    recognizerMetadata: Optional[
      zio.aws.comprehend.model.EntityRecognizerMetadata
    ] = Optional.Absent,
    dataAccessRoleArn: Optional[IamRoleArn] = Optional.Absent,
    volumeKmsKeyId: Optional[KmsKeyId] = Optional.Absent,
    vpcConfig: Optional[zio.aws.comprehend.model.VpcConfig] = Optional.Absent,
    modelKmsKeyId: Optional[KmsKeyId] = Optional.Absent,
    versionName: Optional[VersionName] = Optional.Absent,
    sourceModelArn: Optional[EntityRecognizerArn] = Optional.Absent,
    flywheelArn: Optional[ComprehendFlywheelArn] = Optional.Absent,
    outputDataConfig: Optional[
      zio.aws.comprehend.model.EntityRecognizerOutputDataConfig
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.EntityRecognizerProperties = {
    import EntityRecognizerProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.EntityRecognizerProperties
      .builder()
      .optionallyWith(
        entityRecognizerArn.map(value =>
          EntityRecognizerArn.unwrap(value): java.lang.String
        )
      )(_.entityRecognizerArn)
      .optionallyWith(languageCode.map(value => value.unwrap))(_.languageCode)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        message.map(value => AnyLengthString.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(
        submitTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.submitTime)
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(
        trainingStartTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.trainingStartTime)
      .optionallyWith(
        trainingEndTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.trainingEndTime)
      .optionallyWith(inputDataConfig.map(value => value.buildAwsValue()))(
        _.inputDataConfig
      )
      .optionallyWith(recognizerMetadata.map(value => value.buildAwsValue()))(
        _.recognizerMetadata
      )
      .optionallyWith(
        dataAccessRoleArn.map(value =>
          IamRoleArn.unwrap(value): java.lang.String
        )
      )(_.dataAccessRoleArn)
      .optionallyWith(
        volumeKmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.volumeKmsKeyId)
      .optionallyWith(vpcConfig.map(value => value.buildAwsValue()))(
        _.vpcConfig
      )
      .optionallyWith(
        modelKmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.modelKmsKeyId)
      .optionallyWith(
        versionName.map(value => VersionName.unwrap(value): java.lang.String)
      )(_.versionName)
      .optionallyWith(
        sourceModelArn.map(value =>
          EntityRecognizerArn.unwrap(value): java.lang.String
        )
      )(_.sourceModelArn)
      .optionallyWith(
        flywheelArn.map(value =>
          ComprehendFlywheelArn.unwrap(value): java.lang.String
        )
      )(_.flywheelArn)
      .optionallyWith(outputDataConfig.map(value => value.buildAwsValue()))(
        _.outputDataConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.EntityRecognizerProperties.ReadOnly =
    zio.aws.comprehend.model.EntityRecognizerProperties.wrap(buildAwsValue())
}
object EntityRecognizerProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.EntityRecognizerProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.EntityRecognizerProperties =
      zio.aws.comprehend.model.EntityRecognizerProperties(
        entityRecognizerArn.map(value => value),
        languageCode.map(value => value),
        status.map(value => value),
        message.map(value => value),
        submitTime.map(value => value),
        endTime.map(value => value),
        trainingStartTime.map(value => value),
        trainingEndTime.map(value => value),
        inputDataConfig.map(value => value.asEditable),
        recognizerMetadata.map(value => value.asEditable),
        dataAccessRoleArn.map(value => value),
        volumeKmsKeyId.map(value => value),
        vpcConfig.map(value => value.asEditable),
        modelKmsKeyId.map(value => value),
        versionName.map(value => value),
        sourceModelArn.map(value => value),
        flywheelArn.map(value => value),
        outputDataConfig.map(value => value.asEditable)
      )
    def entityRecognizerArn: Optional[EntityRecognizerArn]
    def languageCode: Optional[zio.aws.comprehend.model.LanguageCode]
    def status: Optional[zio.aws.comprehend.model.ModelStatus]
    def message: Optional[AnyLengthString]
    def submitTime: Optional[Timestamp]
    def endTime: Optional[Timestamp]
    def trainingStartTime: Optional[Timestamp]
    def trainingEndTime: Optional[Timestamp]
    def inputDataConfig: Optional[
      zio.aws.comprehend.model.EntityRecognizerInputDataConfig.ReadOnly
    ]
    def recognizerMetadata
        : Optional[zio.aws.comprehend.model.EntityRecognizerMetadata.ReadOnly]
    def dataAccessRoleArn: Optional[IamRoleArn]
    def volumeKmsKeyId: Optional[KmsKeyId]
    def vpcConfig: Optional[zio.aws.comprehend.model.VpcConfig.ReadOnly]
    def modelKmsKeyId: Optional[KmsKeyId]
    def versionName: Optional[VersionName]
    def sourceModelArn: Optional[EntityRecognizerArn]
    def flywheelArn: Optional[ComprehendFlywheelArn]
    def outputDataConfig: Optional[
      zio.aws.comprehend.model.EntityRecognizerOutputDataConfig.ReadOnly
    ]
    def getEntityRecognizerArn: ZIO[Any, AwsError, EntityRecognizerArn] =
      AwsError.unwrapOptionField("entityRecognizerArn", entityRecognizerArn)
    def getLanguageCode
        : ZIO[Any, AwsError, zio.aws.comprehend.model.LanguageCode] =
      AwsError.unwrapOptionField("languageCode", languageCode)
    def getStatus: ZIO[Any, AwsError, zio.aws.comprehend.model.ModelStatus] =
      AwsError.unwrapOptionField("status", status)
    def getMessage: ZIO[Any, AwsError, AnyLengthString] =
      AwsError.unwrapOptionField("message", message)
    def getSubmitTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("submitTime", submitTime)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getTrainingStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("trainingStartTime", trainingStartTime)
    def getTrainingEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("trainingEndTime", trainingEndTime)
    def getInputDataConfig: ZIO[
      Any,
      AwsError,
      zio.aws.comprehend.model.EntityRecognizerInputDataConfig.ReadOnly
    ] = AwsError.unwrapOptionField("inputDataConfig", inputDataConfig)
    def getRecognizerMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.comprehend.model.EntityRecognizerMetadata.ReadOnly
    ] = AwsError.unwrapOptionField("recognizerMetadata", recognizerMetadata)
    def getDataAccessRoleArn: ZIO[Any, AwsError, IamRoleArn] =
      AwsError.unwrapOptionField("dataAccessRoleArn", dataAccessRoleArn)
    def getVolumeKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("volumeKmsKeyId", volumeKmsKeyId)
    def getVpcConfig
        : ZIO[Any, AwsError, zio.aws.comprehend.model.VpcConfig.ReadOnly] =
      AwsError.unwrapOptionField("vpcConfig", vpcConfig)
    def getModelKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("modelKmsKeyId", modelKmsKeyId)
    def getVersionName: ZIO[Any, AwsError, VersionName] =
      AwsError.unwrapOptionField("versionName", versionName)
    def getSourceModelArn: ZIO[Any, AwsError, EntityRecognizerArn] =
      AwsError.unwrapOptionField("sourceModelArn", sourceModelArn)
    def getFlywheelArn: ZIO[Any, AwsError, ComprehendFlywheelArn] =
      AwsError.unwrapOptionField("flywheelArn", flywheelArn)
    def getOutputDataConfig: ZIO[
      Any,
      AwsError,
      zio.aws.comprehend.model.EntityRecognizerOutputDataConfig.ReadOnly
    ] = AwsError.unwrapOptionField("outputDataConfig", outputDataConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.EntityRecognizerProperties
  ) extends zio.aws.comprehend.model.EntityRecognizerProperties.ReadOnly {
    override val entityRecognizerArn: Optional[EntityRecognizerArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.entityRecognizerArn())
        .map(value =>
          zio.aws.comprehend.model.primitives.EntityRecognizerArn(value)
        )
    override val languageCode: Optional[zio.aws.comprehend.model.LanguageCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.languageCode())
        .map(value => zio.aws.comprehend.model.LanguageCode.wrap(value))
    override val status: Optional[zio.aws.comprehend.model.ModelStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.comprehend.model.ModelStatus.wrap(value))
    override val message: Optional[AnyLengthString] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => zio.aws.comprehend.model.primitives.AnyLengthString(value))
    override val submitTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.submitTime())
      .map(value => zio.aws.comprehend.model.primitives.Timestamp(value))
    override val endTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.comprehend.model.primitives.Timestamp(value))
    override val trainingStartTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.trainingStartTime())
      .map(value => zio.aws.comprehend.model.primitives.Timestamp(value))
    override val trainingEndTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.trainingEndTime())
      .map(value => zio.aws.comprehend.model.primitives.Timestamp(value))
    override val inputDataConfig: Optional[
      zio.aws.comprehend.model.EntityRecognizerInputDataConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.inputDataConfig())
      .map(value =>
        zio.aws.comprehend.model.EntityRecognizerInputDataConfig.wrap(value)
      )
    override val recognizerMetadata
        : Optional[zio.aws.comprehend.model.EntityRecognizerMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recognizerMetadata())
        .map(value =>
          zio.aws.comprehend.model.EntityRecognizerMetadata.wrap(value)
        )
    override val dataAccessRoleArn: Optional[IamRoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.dataAccessRoleArn())
      .map(value => zio.aws.comprehend.model.primitives.IamRoleArn(value))
    override val volumeKmsKeyId: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.volumeKmsKeyId())
      .map(value => zio.aws.comprehend.model.primitives.KmsKeyId(value))
    override val vpcConfig
        : Optional[zio.aws.comprehend.model.VpcConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcConfig())
        .map(value => zio.aws.comprehend.model.VpcConfig.wrap(value))
    override val modelKmsKeyId: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.modelKmsKeyId())
      .map(value => zio.aws.comprehend.model.primitives.KmsKeyId(value))
    override val versionName: Optional[VersionName] = zio.aws.core.internal
      .optionalFromNullable(impl.versionName())
      .map(value => zio.aws.comprehend.model.primitives.VersionName(value))
    override val sourceModelArn: Optional[EntityRecognizerArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceModelArn())
        .map(value =>
          zio.aws.comprehend.model.primitives.EntityRecognizerArn(value)
        )
    override val flywheelArn: Optional[ComprehendFlywheelArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.flywheelArn())
        .map(value =>
          zio.aws.comprehend.model.primitives.ComprehendFlywheelArn(value)
        )
    override val outputDataConfig: Optional[
      zio.aws.comprehend.model.EntityRecognizerOutputDataConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.outputDataConfig())
      .map(value =>
        zio.aws.comprehend.model.EntityRecognizerOutputDataConfig.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.EntityRecognizerProperties
  ): zio.aws.comprehend.model.EntityRecognizerProperties.ReadOnly = new Wrapper(
    impl
  )
}
