package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.{
  SemiStructuredDocumentBlob,
  EntityRecognizerEndpointArn,
  CustomerInputString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DetectEntitiesRequest(
    text: Optional[CustomerInputString] = Optional.Absent,
    languageCode: Optional[zio.aws.comprehend.model.LanguageCode] =
      Optional.Absent,
    endpointArn: Optional[EntityRecognizerEndpointArn] = Optional.Absent,
    bytes: Optional[SemiStructuredDocumentBlob] = Optional.Absent,
    documentReaderConfig: Optional[
      zio.aws.comprehend.model.DocumentReaderConfig
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.DetectEntitiesRequest = {
    import DetectEntitiesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.DetectEntitiesRequest
      .builder()
      .optionallyWith(
        text.map(value => CustomerInputString.unwrap(value): java.lang.String)
      )(_.text)
      .optionallyWith(languageCode.map(value => value.unwrap))(_.languageCode)
      .optionallyWith(
        endpointArn.map(value =>
          EntityRecognizerEndpointArn.unwrap(value): java.lang.String
        )
      )(_.endpointArn)
      .optionallyWith(
        bytes.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.bytes)
      .optionallyWith(documentReaderConfig.map(value => value.buildAwsValue()))(
        _.documentReaderConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.DetectEntitiesRequest.ReadOnly =
    zio.aws.comprehend.model.DetectEntitiesRequest.wrap(buildAwsValue())
}
object DetectEntitiesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.DetectEntitiesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.DetectEntitiesRequest =
      zio.aws.comprehend.model.DetectEntitiesRequest(
        text.map(value => value),
        languageCode.map(value => value),
        endpointArn.map(value => value),
        bytes.map(value => value),
        documentReaderConfig.map(value => value.asEditable)
      )
    def text: Optional[CustomerInputString]
    def languageCode: Optional[zio.aws.comprehend.model.LanguageCode]
    def endpointArn: Optional[EntityRecognizerEndpointArn]
    def bytes: Optional[SemiStructuredDocumentBlob]
    def documentReaderConfig
        : Optional[zio.aws.comprehend.model.DocumentReaderConfig.ReadOnly]
    def getText: ZIO[Any, AwsError, CustomerInputString] =
      AwsError.unwrapOptionField("text", text)
    def getLanguageCode
        : ZIO[Any, AwsError, zio.aws.comprehend.model.LanguageCode] =
      AwsError.unwrapOptionField("languageCode", languageCode)
    def getEndpointArn: ZIO[Any, AwsError, EntityRecognizerEndpointArn] =
      AwsError.unwrapOptionField("endpointArn", endpointArn)
    def getBytes: ZIO[Any, AwsError, SemiStructuredDocumentBlob] =
      AwsError.unwrapOptionField("bytes", bytes)
    def getDocumentReaderConfig: ZIO[
      Any,
      AwsError,
      zio.aws.comprehend.model.DocumentReaderConfig.ReadOnly
    ] = AwsError.unwrapOptionField("documentReaderConfig", documentReaderConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.DetectEntitiesRequest
  ) extends zio.aws.comprehend.model.DetectEntitiesRequest.ReadOnly {
    override val text: Optional[CustomerInputString] = zio.aws.core.internal
      .optionalFromNullable(impl.text())
      .map(value =>
        zio.aws.comprehend.model.primitives.CustomerInputString(value)
      )
    override val languageCode: Optional[zio.aws.comprehend.model.LanguageCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.languageCode())
        .map(value => zio.aws.comprehend.model.LanguageCode.wrap(value))
    override val endpointArn: Optional[EntityRecognizerEndpointArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endpointArn())
        .map(value =>
          zio.aws.comprehend.model.primitives.EntityRecognizerEndpointArn(value)
        )
    override val bytes: Optional[SemiStructuredDocumentBlob] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bytes())
        .map(value =>
          zio.aws.comprehend.model.primitives.SemiStructuredDocumentBlob(
            zio.Chunk.fromArray(value.asByteArrayUnsafe())
          )
        )
    override val documentReaderConfig
        : Optional[zio.aws.comprehend.model.DocumentReaderConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentReaderConfig())
        .map(value => zio.aws.comprehend.model.DocumentReaderConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.DetectEntitiesRequest
  ): zio.aws.comprehend.model.DetectEntitiesRequest.ReadOnly = new Wrapper(impl)
}
