package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.{S3Uri, AttributeNamesListItem}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DatasetAugmentedManifestsListItem(
    attributeNames: Iterable[AttributeNamesListItem],
    s3Uri: S3Uri,
    annotationDataS3Uri: Optional[S3Uri] = Optional.Absent,
    sourceDocumentsS3Uri: Optional[S3Uri] = Optional.Absent,
    documentType: Optional[
      zio.aws.comprehend.model.AugmentedManifestsDocumentTypeFormat
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.DatasetAugmentedManifestsListItem = {
    import DatasetAugmentedManifestsListItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.DatasetAugmentedManifestsListItem
      .builder()
      .attributeNames(attributeNames.map { item =>
        AttributeNamesListItem.unwrap(item): java.lang.String
      }.asJavaCollection)
      .s3Uri(S3Uri.unwrap(s3Uri): java.lang.String)
      .optionallyWith(
        annotationDataS3Uri.map(value => S3Uri.unwrap(value): java.lang.String)
      )(_.annotationDataS3Uri)
      .optionallyWith(
        sourceDocumentsS3Uri.map(value => S3Uri.unwrap(value): java.lang.String)
      )(_.sourceDocumentsS3Uri)
      .optionallyWith(documentType.map(value => value.unwrap))(_.documentType)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.DatasetAugmentedManifestsListItem.ReadOnly =
    zio.aws.comprehend.model.DatasetAugmentedManifestsListItem
      .wrap(buildAwsValue())
}
object DatasetAugmentedManifestsListItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.DatasetAugmentedManifestsListItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.DatasetAugmentedManifestsListItem =
      zio.aws.comprehend.model.DatasetAugmentedManifestsListItem(
        attributeNames,
        s3Uri,
        annotationDataS3Uri.map(value => value),
        sourceDocumentsS3Uri.map(value => value),
        documentType.map(value => value)
      )
    def attributeNames: List[AttributeNamesListItem]
    def s3Uri: S3Uri
    def annotationDataS3Uri: Optional[S3Uri]
    def sourceDocumentsS3Uri: Optional[S3Uri]
    def documentType: Optional[
      zio.aws.comprehend.model.AugmentedManifestsDocumentTypeFormat
    ]
    def getAttributeNames: ZIO[Any, Nothing, List[AttributeNamesListItem]] =
      ZIO.succeed(attributeNames)
    def getS3Uri: ZIO[Any, Nothing, S3Uri] = ZIO.succeed(s3Uri)
    def getAnnotationDataS3Uri: ZIO[Any, AwsError, S3Uri] =
      AwsError.unwrapOptionField("annotationDataS3Uri", annotationDataS3Uri)
    def getSourceDocumentsS3Uri: ZIO[Any, AwsError, S3Uri] =
      AwsError.unwrapOptionField("sourceDocumentsS3Uri", sourceDocumentsS3Uri)
    def getDocumentType: ZIO[
      Any,
      AwsError,
      zio.aws.comprehend.model.AugmentedManifestsDocumentTypeFormat
    ] = AwsError.unwrapOptionField("documentType", documentType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.DatasetAugmentedManifestsListItem
  ) extends zio.aws.comprehend.model.DatasetAugmentedManifestsListItem.ReadOnly {
    override val attributeNames: List[AttributeNamesListItem] = impl
      .attributeNames()
      .asScala
      .map { item =>
        zio.aws.comprehend.model.primitives.AttributeNamesListItem(item)
      }
      .toList
    override val s3Uri: S3Uri =
      zio.aws.comprehend.model.primitives.S3Uri(impl.s3Uri())
    override val annotationDataS3Uri: Optional[S3Uri] = zio.aws.core.internal
      .optionalFromNullable(impl.annotationDataS3Uri())
      .map(value => zio.aws.comprehend.model.primitives.S3Uri(value))
    override val sourceDocumentsS3Uri: Optional[S3Uri] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceDocumentsS3Uri())
      .map(value => zio.aws.comprehend.model.primitives.S3Uri(value))
    override val documentType: Optional[
      zio.aws.comprehend.model.AugmentedManifestsDocumentTypeFormat
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.documentType())
      .map(value =>
        zio.aws.comprehend.model.AugmentedManifestsDocumentTypeFormat
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.DatasetAugmentedManifestsListItem
  ): zio.aws.comprehend.model.DatasetAugmentedManifestsListItem.ReadOnly =
    new Wrapper(impl)
}
