package zio.aws.comprehend.model
import scala.jdk.CollectionConverters.*
sealed trait PageBasedWarningCode {
  def unwrap
      : software.amazon.awssdk.services.comprehend.model.PageBasedWarningCode
}
object PageBasedWarningCode {
  def wrap(
      value: software.amazon.awssdk.services.comprehend.model.PageBasedWarningCode
  ): zio.aws.comprehend.model.PageBasedWarningCode = value match {
    case software.amazon.awssdk.services.comprehend.model.PageBasedWarningCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.comprehend.model.PageBasedWarningCode.INFERENCING_PLAINTEXT_WITH_NATIVE_TRAINED_MODEL =>
      val r = INFERENCING_PLAINTEXT_WITH_NATIVE_TRAINED_MODEL
      r
    case software.amazon.awssdk.services.comprehend.model.PageBasedWarningCode.INFERENCING_NATIVE_DOCUMENT_WITH_PLAINTEXT_TRAINED_MODEL =>
      val r = INFERENCING_NATIVE_DOCUMENT_WITH_PLAINTEXT_TRAINED_MODEL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.comprehend.model.PageBasedWarningCode {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.PageBasedWarningCode =
      software.amazon.awssdk.services.comprehend.model.PageBasedWarningCode.UNKNOWN_TO_SDK_VERSION
  }
  case object INFERENCING_PLAINTEXT_WITH_NATIVE_TRAINED_MODEL
      extends zio.aws.comprehend.model.PageBasedWarningCode {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.PageBasedWarningCode =
      software.amazon.awssdk.services.comprehend.model.PageBasedWarningCode.INFERENCING_PLAINTEXT_WITH_NATIVE_TRAINED_MODEL
  }
  case object INFERENCING_NATIVE_DOCUMENT_WITH_PLAINTEXT_TRAINED_MODEL
      extends zio.aws.comprehend.model.PageBasedWarningCode {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.PageBasedWarningCode =
      software.amazon.awssdk.services.comprehend.model.PageBasedWarningCode.INFERENCING_NATIVE_DOCUMENT_WITH_PLAINTEXT_TRAINED_MODEL
  }
}
