package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.S3Uri
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DocumentClassifierDocuments(
    s3Uri: S3Uri,
    testS3Uri: Optional[S3Uri] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.DocumentClassifierDocuments = {
    import DocumentClassifierDocuments.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.DocumentClassifierDocuments
      .builder()
      .s3Uri(S3Uri.unwrap(s3Uri): java.lang.String)
      .optionallyWith(
        testS3Uri.map(value => S3Uri.unwrap(value): java.lang.String)
      )(_.testS3Uri)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.DocumentClassifierDocuments.ReadOnly =
    zio.aws.comprehend.model.DocumentClassifierDocuments.wrap(buildAwsValue())
}
object DocumentClassifierDocuments {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.DocumentClassifierDocuments
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.DocumentClassifierDocuments =
      zio.aws.comprehend.model
        .DocumentClassifierDocuments(s3Uri, testS3Uri.map(value => value))
    def s3Uri: S3Uri
    def testS3Uri: Optional[S3Uri]
    def getS3Uri: ZIO[Any, Nothing, S3Uri] = ZIO.succeed(s3Uri)
    def getTestS3Uri: ZIO[Any, AwsError, S3Uri] =
      AwsError.unwrapOptionField("testS3Uri", testS3Uri)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.DocumentClassifierDocuments
  ) extends zio.aws.comprehend.model.DocumentClassifierDocuments.ReadOnly {
    override val s3Uri: S3Uri =
      zio.aws.comprehend.model.primitives.S3Uri(impl.s3Uri())
    override val testS3Uri: Optional[S3Uri] = zio.aws.core.internal
      .optionalFromNullable(impl.testS3Uri())
      .map(value => zio.aws.comprehend.model.primitives.S3Uri(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.DocumentClassifierDocuments
  ): zio.aws.comprehend.model.DocumentClassifierDocuments.ReadOnly =
    new Wrapper(impl)
}
