package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.{
  FlywheelIterationId,
  ComprehendFlywheelArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class StartFlywheelIterationResponse(
    flywheelArn: Optional[ComprehendFlywheelArn] = Optional.Absent,
    flywheelIterationId: Optional[FlywheelIterationId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.StartFlywheelIterationResponse = {
    import StartFlywheelIterationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.StartFlywheelIterationResponse
      .builder()
      .optionallyWith(
        flywheelArn.map(value =>
          ComprehendFlywheelArn.unwrap(value): java.lang.String
        )
      )(_.flywheelArn)
      .optionallyWith(
        flywheelIterationId.map(value =>
          FlywheelIterationId.unwrap(value): java.lang.String
        )
      )(_.flywheelIterationId)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.StartFlywheelIterationResponse.ReadOnly =
    zio.aws.comprehend.model.StartFlywheelIterationResponse
      .wrap(buildAwsValue())
}
object StartFlywheelIterationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.StartFlywheelIterationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.StartFlywheelIterationResponse =
      zio.aws.comprehend.model.StartFlywheelIterationResponse(
        flywheelArn.map(value => value),
        flywheelIterationId.map(value => value)
      )
    def flywheelArn: Optional[ComprehendFlywheelArn]
    def flywheelIterationId: Optional[FlywheelIterationId]
    def getFlywheelArn: ZIO[Any, AwsError, ComprehendFlywheelArn] =
      AwsError.unwrapOptionField("flywheelArn", flywheelArn)
    def getFlywheelIterationId: ZIO[Any, AwsError, FlywheelIterationId] =
      AwsError.unwrapOptionField("flywheelIterationId", flywheelIterationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.StartFlywheelIterationResponse
  ) extends zio.aws.comprehend.model.StartFlywheelIterationResponse.ReadOnly {
    override val flywheelArn: Optional[ComprehendFlywheelArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.flywheelArn())
        .map(value =>
          zio.aws.comprehend.model.primitives.ComprehendFlywheelArn(value)
        )
    override val flywheelIterationId: Optional[FlywheelIterationId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.flywheelIterationId())
        .map(value =>
          zio.aws.comprehend.model.primitives.FlywheelIterationId(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.StartFlywheelIterationResponse
  ): zio.aws.comprehend.model.StartFlywheelIterationResponse.ReadOnly =
    new Wrapper(impl)
}
