package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.{
  EntityRecognizerArn,
  ComprehendArn,
  JobId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class StartEntitiesDetectionJobResponse(
    jobId: Optional[JobId] = Optional.Absent,
    jobArn: Optional[ComprehendArn] = Optional.Absent,
    jobStatus: Optional[zio.aws.comprehend.model.JobStatus] = Optional.Absent,
    entityRecognizerArn: Optional[EntityRecognizerArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.StartEntitiesDetectionJobResponse = {
    import StartEntitiesDetectionJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.StartEntitiesDetectionJobResponse
      .builder()
      .optionallyWith(
        jobId.map(value => JobId.unwrap(value): java.lang.String)
      )(_.jobId)
      .optionallyWith(
        jobArn.map(value => ComprehendArn.unwrap(value): java.lang.String)
      )(_.jobArn)
      .optionallyWith(jobStatus.map(value => value.unwrap))(_.jobStatus)
      .optionallyWith(
        entityRecognizerArn.map(value =>
          EntityRecognizerArn.unwrap(value): java.lang.String
        )
      )(_.entityRecognizerArn)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.StartEntitiesDetectionJobResponse.ReadOnly =
    zio.aws.comprehend.model.StartEntitiesDetectionJobResponse
      .wrap(buildAwsValue())
}
object StartEntitiesDetectionJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.StartEntitiesDetectionJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.StartEntitiesDetectionJobResponse =
      zio.aws.comprehend.model.StartEntitiesDetectionJobResponse(
        jobId.map(value => value),
        jobArn.map(value => value),
        jobStatus.map(value => value),
        entityRecognizerArn.map(value => value)
      )
    def jobId: Optional[JobId]
    def jobArn: Optional[ComprehendArn]
    def jobStatus: Optional[zio.aws.comprehend.model.JobStatus]
    def entityRecognizerArn: Optional[EntityRecognizerArn]
    def getJobId: ZIO[Any, AwsError, JobId] =
      AwsError.unwrapOptionField("jobId", jobId)
    def getJobArn: ZIO[Any, AwsError, ComprehendArn] =
      AwsError.unwrapOptionField("jobArn", jobArn)
    def getJobStatus: ZIO[Any, AwsError, zio.aws.comprehend.model.JobStatus] =
      AwsError.unwrapOptionField("jobStatus", jobStatus)
    def getEntityRecognizerArn: ZIO[Any, AwsError, EntityRecognizerArn] =
      AwsError.unwrapOptionField("entityRecognizerArn", entityRecognizerArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.StartEntitiesDetectionJobResponse
  ) extends zio.aws.comprehend.model.StartEntitiesDetectionJobResponse.ReadOnly {
    override val jobId: Optional[JobId] = zio.aws.core.internal
      .optionalFromNullable(impl.jobId())
      .map(value => zio.aws.comprehend.model.primitives.JobId(value))
    override val jobArn: Optional[ComprehendArn] = zio.aws.core.internal
      .optionalFromNullable(impl.jobArn())
      .map(value => zio.aws.comprehend.model.primitives.ComprehendArn(value))
    override val jobStatus: Optional[zio.aws.comprehend.model.JobStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobStatus())
        .map(value => zio.aws.comprehend.model.JobStatus.wrap(value))
    override val entityRecognizerArn: Optional[EntityRecognizerArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.entityRecognizerArn())
        .map(value =>
          zio.aws.comprehend.model.primitives.EntityRecognizerArn(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.StartEntitiesDetectionJobResponse
  ): zio.aws.comprehend.model.StartEntitiesDetectionJobResponse.ReadOnly =
    new Wrapper(impl)
}
