package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.S3Uri
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class EntityRecognizerAnnotations(
    s3Uri: S3Uri,
    testS3Uri: Optional[S3Uri] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.EntityRecognizerAnnotations = {
    import EntityRecognizerAnnotations.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.EntityRecognizerAnnotations
      .builder()
      .s3Uri(S3Uri.unwrap(s3Uri): java.lang.String)
      .optionallyWith(
        testS3Uri.map(value => S3Uri.unwrap(value): java.lang.String)
      )(_.testS3Uri)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.EntityRecognizerAnnotations.ReadOnly =
    zio.aws.comprehend.model.EntityRecognizerAnnotations.wrap(buildAwsValue())
}
object EntityRecognizerAnnotations {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.EntityRecognizerAnnotations
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.EntityRecognizerAnnotations =
      zio.aws.comprehend.model
        .EntityRecognizerAnnotations(s3Uri, testS3Uri.map(value => value))
    def s3Uri: S3Uri
    def testS3Uri: Optional[S3Uri]
    def getS3Uri: ZIO[Any, Nothing, S3Uri] = ZIO.succeed(s3Uri)
    def getTestS3Uri: ZIO[Any, AwsError, S3Uri] =
      AwsError.unwrapOptionField("testS3Uri", testS3Uri)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.EntityRecognizerAnnotations
  ) extends zio.aws.comprehend.model.EntityRecognizerAnnotations.ReadOnly {
    override val s3Uri: S3Uri =
      zio.aws.comprehend.model.primitives.S3Uri(impl.s3Uri())
    override val testS3Uri: Optional[S3Uri] = zio.aws.core.internal
      .optionalFromNullable(impl.testS3Uri())
      .map(value => zio.aws.comprehend.model.primitives.S3Uri(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.EntityRecognizerAnnotations
  ): zio.aws.comprehend.model.EntityRecognizerAnnotations.ReadOnly =
    new Wrapper(impl)
}
