package zio.aws.comprehend.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DetectPiiEntitiesRequest(
    text: String,
    languageCode: zio.aws.comprehend.model.LanguageCode
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.DetectPiiEntitiesRequest = {
    import DetectPiiEntitiesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.DetectPiiEntitiesRequest
      .builder()
      .text(text: java.lang.String)
      .languageCode(languageCode.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.DetectPiiEntitiesRequest.ReadOnly =
    zio.aws.comprehend.model.DetectPiiEntitiesRequest.wrap(buildAwsValue())
}
object DetectPiiEntitiesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.DetectPiiEntitiesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.DetectPiiEntitiesRequest =
      zio.aws.comprehend.model.DetectPiiEntitiesRequest(text, languageCode)
    def text: String
    def languageCode: zio.aws.comprehend.model.LanguageCode
    def getText: ZIO[Any, Nothing, String] = ZIO.succeed(text)
    def getLanguageCode
        : ZIO[Any, Nothing, zio.aws.comprehend.model.LanguageCode] =
      ZIO.succeed(languageCode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.DetectPiiEntitiesRequest
  ) extends zio.aws.comprehend.model.DetectPiiEntitiesRequest.ReadOnly {
    override val text: String = impl.text(): String
    override val languageCode: zio.aws.comprehend.model.LanguageCode =
      zio.aws.comprehend.model.LanguageCode.wrap(impl.languageCode())
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.DetectPiiEntitiesRequest
  ): zio.aws.comprehend.model.DetectPiiEntitiesRequest.ReadOnly = new Wrapper(
    impl
  )
}
