package zio.aws.comprehend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DetectEntitiesResponse(
    entities: Optional[Iterable[zio.aws.comprehend.model.Entity]] =
      Optional.Absent,
    documentMetadata: Optional[zio.aws.comprehend.model.DocumentMetadata] =
      Optional.Absent,
    documentType: Optional[
      Iterable[zio.aws.comprehend.model.DocumentTypeListItem]
    ] = Optional.Absent,
    blocks: Optional[Iterable[zio.aws.comprehend.model.Block]] =
      Optional.Absent,
    errors: Optional[Iterable[zio.aws.comprehend.model.ErrorsListItem]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.DetectEntitiesResponse = {
    import DetectEntitiesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.DetectEntitiesResponse
      .builder()
      .optionallyWith(
        entities.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.entities)
      .optionallyWith(documentMetadata.map(value => value.buildAwsValue()))(
        _.documentMetadata
      )
      .optionallyWith(
        documentType.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.documentType)
      .optionallyWith(
        blocks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.blocks)
      .optionallyWith(
        errors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.errors)
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.DetectEntitiesResponse.ReadOnly =
    zio.aws.comprehend.model.DetectEntitiesResponse.wrap(buildAwsValue())
}
object DetectEntitiesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.DetectEntitiesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.DetectEntitiesResponse =
      zio.aws.comprehend.model.DetectEntitiesResponse(
        entities.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        documentMetadata.map(value => value.asEditable),
        documentType.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        blocks.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        errors.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def entities: Optional[List[zio.aws.comprehend.model.Entity.ReadOnly]]
    def documentMetadata
        : Optional[zio.aws.comprehend.model.DocumentMetadata.ReadOnly]
    def documentType
        : Optional[List[zio.aws.comprehend.model.DocumentTypeListItem.ReadOnly]]
    def blocks: Optional[List[zio.aws.comprehend.model.Block.ReadOnly]]
    def errors: Optional[List[zio.aws.comprehend.model.ErrorsListItem.ReadOnly]]
    def getEntities
        : ZIO[Any, AwsError, List[zio.aws.comprehend.model.Entity.ReadOnly]] =
      AwsError.unwrapOptionField("entities", entities)
    def getDocumentMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.comprehend.model.DocumentMetadata.ReadOnly
    ] = AwsError.unwrapOptionField("documentMetadata", documentMetadata)
    def getDocumentType: ZIO[Any, AwsError, List[
      zio.aws.comprehend.model.DocumentTypeListItem.ReadOnly
    ]] = AwsError.unwrapOptionField("documentType", documentType)
    def getBlocks
        : ZIO[Any, AwsError, List[zio.aws.comprehend.model.Block.ReadOnly]] =
      AwsError.unwrapOptionField("blocks", blocks)
    def getErrors: ZIO[Any, AwsError, List[
      zio.aws.comprehend.model.ErrorsListItem.ReadOnly
    ]] = AwsError.unwrapOptionField("errors", errors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.DetectEntitiesResponse
  ) extends zio.aws.comprehend.model.DetectEntitiesResponse.ReadOnly {
    override val entities
        : Optional[List[zio.aws.comprehend.model.Entity.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.entities())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.comprehend.model.Entity.wrap(item)
          }.toList
        )
    override val documentMetadata
        : Optional[zio.aws.comprehend.model.DocumentMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentMetadata())
        .map(value => zio.aws.comprehend.model.DocumentMetadata.wrap(value))
    override val documentType: Optional[
      List[zio.aws.comprehend.model.DocumentTypeListItem.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.documentType())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.comprehend.model.DocumentTypeListItem.wrap(item)
        }.toList
      )
    override val blocks
        : Optional[List[zio.aws.comprehend.model.Block.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.blocks())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.comprehend.model.Block.wrap(item)
          }.toList
        )
    override val errors
        : Optional[List[zio.aws.comprehend.model.ErrorsListItem.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.comprehend.model.ErrorsListItem.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.DetectEntitiesResponse
  ): zio.aws.comprehend.model.DetectEntitiesResponse.ReadOnly = new Wrapper(
    impl
  )
}
