package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.{
  IamRoleArn,
  ComprehendModelArn,
  ComprehendFlywheelArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateFlywheelRequest(
    flywheelArn: ComprehendFlywheelArn,
    activeModelArn: Optional[ComprehendModelArn] = Optional.Absent,
    dataAccessRoleArn: Optional[IamRoleArn] = Optional.Absent,
    dataSecurityConfig: Optional[
      zio.aws.comprehend.model.UpdateDataSecurityConfig
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.UpdateFlywheelRequest = {
    import UpdateFlywheelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.UpdateFlywheelRequest
      .builder()
      .flywheelArn(ComprehendFlywheelArn.unwrap(flywheelArn): java.lang.String)
      .optionallyWith(
        activeModelArn.map(value =>
          ComprehendModelArn.unwrap(value): java.lang.String
        )
      )(_.activeModelArn)
      .optionallyWith(
        dataAccessRoleArn.map(value =>
          IamRoleArn.unwrap(value): java.lang.String
        )
      )(_.dataAccessRoleArn)
      .optionallyWith(dataSecurityConfig.map(value => value.buildAwsValue()))(
        _.dataSecurityConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.UpdateFlywheelRequest.ReadOnly =
    zio.aws.comprehend.model.UpdateFlywheelRequest.wrap(buildAwsValue())
}
object UpdateFlywheelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.UpdateFlywheelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.UpdateFlywheelRequest =
      zio.aws.comprehend.model.UpdateFlywheelRequest(
        flywheelArn,
        activeModelArn.map(value => value),
        dataAccessRoleArn.map(value => value),
        dataSecurityConfig.map(value => value.asEditable)
      )
    def flywheelArn: ComprehendFlywheelArn
    def activeModelArn: Optional[ComprehendModelArn]
    def dataAccessRoleArn: Optional[IamRoleArn]
    def dataSecurityConfig
        : Optional[zio.aws.comprehend.model.UpdateDataSecurityConfig.ReadOnly]
    def getFlywheelArn: ZIO[Any, Nothing, ComprehendFlywheelArn] =
      ZIO.succeed(flywheelArn)
    def getActiveModelArn: ZIO[Any, AwsError, ComprehendModelArn] =
      AwsError.unwrapOptionField("activeModelArn", activeModelArn)
    def getDataAccessRoleArn: ZIO[Any, AwsError, IamRoleArn] =
      AwsError.unwrapOptionField("dataAccessRoleArn", dataAccessRoleArn)
    def getDataSecurityConfig: ZIO[
      Any,
      AwsError,
      zio.aws.comprehend.model.UpdateDataSecurityConfig.ReadOnly
    ] = AwsError.unwrapOptionField("dataSecurityConfig", dataSecurityConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.UpdateFlywheelRequest
  ) extends zio.aws.comprehend.model.UpdateFlywheelRequest.ReadOnly {
    override val flywheelArn: ComprehendFlywheelArn =
      zio.aws.comprehend.model.primitives
        .ComprehendFlywheelArn(impl.flywheelArn())
    override val activeModelArn: Optional[ComprehendModelArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.activeModelArn())
        .map(value =>
          zio.aws.comprehend.model.primitives.ComprehendModelArn(value)
        )
    override val dataAccessRoleArn: Optional[IamRoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.dataAccessRoleArn())
      .map(value => zio.aws.comprehend.model.primitives.IamRoleArn(value))
    override val dataSecurityConfig
        : Optional[zio.aws.comprehend.model.UpdateDataSecurityConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataSecurityConfig())
        .map(value =>
          zio.aws.comprehend.model.UpdateDataSecurityConfig.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.UpdateFlywheelRequest
  ): zio.aws.comprehend.model.UpdateFlywheelRequest.ReadOnly = new Wrapper(impl)
}
