package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.CustomerInputString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DetectSentimentRequest(
    text: CustomerInputString,
    languageCode: zio.aws.comprehend.model.LanguageCode
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.DetectSentimentRequest = {
    import DetectSentimentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.DetectSentimentRequest
      .builder()
      .text(CustomerInputString.unwrap(text): java.lang.String)
      .languageCode(languageCode.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.DetectSentimentRequest.ReadOnly =
    zio.aws.comprehend.model.DetectSentimentRequest.wrap(buildAwsValue())
}
object DetectSentimentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.DetectSentimentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.DetectSentimentRequest =
      zio.aws.comprehend.model.DetectSentimentRequest(text, languageCode)
    def text: CustomerInputString
    def languageCode: zio.aws.comprehend.model.LanguageCode
    def getText: ZIO[Any, Nothing, CustomerInputString] = ZIO.succeed(text)
    def getLanguageCode
        : ZIO[Any, Nothing, zio.aws.comprehend.model.LanguageCode] =
      ZIO.succeed(languageCode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.DetectSentimentRequest
  ) extends zio.aws.comprehend.model.DetectSentimentRequest.ReadOnly {
    override val text: CustomerInputString =
      zio.aws.comprehend.model.primitives.CustomerInputString(impl.text())
    override val languageCode: zio.aws.comprehend.model.LanguageCode =
      zio.aws.comprehend.model.LanguageCode.wrap(impl.languageCode())
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.DetectSentimentRequest
  ): zio.aws.comprehend.model.DetectSentimentRequest.ReadOnly = new Wrapper(
    impl
  )
}
