package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.JobId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeKeyPhrasesDetectionJobRequest(jobId: JobId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.DescribeKeyPhrasesDetectionJobRequest = {
    import DescribeKeyPhrasesDetectionJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.DescribeKeyPhrasesDetectionJobRequest
      .builder()
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.DescribeKeyPhrasesDetectionJobRequest.ReadOnly =
    zio.aws.comprehend.model.DescribeKeyPhrasesDetectionJobRequest
      .wrap(buildAwsValue())
}
object DescribeKeyPhrasesDetectionJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.DescribeKeyPhrasesDetectionJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.comprehend.model.DescribeKeyPhrasesDetectionJobRequest =
      zio.aws.comprehend.model.DescribeKeyPhrasesDetectionJobRequest(jobId)
    def jobId: JobId
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.DescribeKeyPhrasesDetectionJobRequest
  ) extends zio.aws.comprehend.model.DescribeKeyPhrasesDetectionJobRequest.ReadOnly {
    override val jobId: JobId =
      zio.aws.comprehend.model.primitives.JobId(impl.jobId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.DescribeKeyPhrasesDetectionJobRequest
  ): zio.aws.comprehend.model.DescribeKeyPhrasesDetectionJobRequest.ReadOnly =
    new Wrapper(impl)
}
