package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.EntityRecognizerArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeEntityRecognizerRequest(
    entityRecognizerArn: EntityRecognizerArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.DescribeEntityRecognizerRequest = {
    import DescribeEntityRecognizerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.DescribeEntityRecognizerRequest
      .builder()
      .entityRecognizerArn(
        EntityRecognizerArn.unwrap(entityRecognizerArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.DescribeEntityRecognizerRequest.ReadOnly =
    zio.aws.comprehend.model.DescribeEntityRecognizerRequest
      .wrap(buildAwsValue())
}
object DescribeEntityRecognizerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.DescribeEntityRecognizerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.DescribeEntityRecognizerRequest =
      zio.aws.comprehend.model
        .DescribeEntityRecognizerRequest(entityRecognizerArn)
    def entityRecognizerArn: EntityRecognizerArn
    def getEntityRecognizerArn: ZIO[Any, Nothing, EntityRecognizerArn] =
      ZIO.succeed(entityRecognizerArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.DescribeEntityRecognizerRequest
  ) extends zio.aws.comprehend.model.DescribeEntityRecognizerRequest.ReadOnly {
    override val entityRecognizerArn: EntityRecognizerArn =
      zio.aws.comprehend.model.primitives
        .EntityRecognizerArn(impl.entityRecognizerArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.DescribeEntityRecognizerRequest
  ): zio.aws.comprehend.model.DescribeEntityRecognizerRequest.ReadOnly =
    new Wrapper(impl)
}
