package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BatchDetectSentimentItemResult(
    index: Optional[Integer] = Optional.Absent,
    sentiment: Optional[zio.aws.comprehend.model.SentimentType] =
      Optional.Absent,
    sentimentScore: Optional[zio.aws.comprehend.model.SentimentScore] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.BatchDetectSentimentItemResult = {
    import BatchDetectSentimentItemResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.BatchDetectSentimentItemResult
      .builder()
      .optionallyWith(index.map(value => value: java.lang.Integer))(_.index)
      .optionallyWith(sentiment.map(value => value.unwrap))(_.sentiment)
      .optionallyWith(sentimentScore.map(value => value.buildAwsValue()))(
        _.sentimentScore
      )
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.BatchDetectSentimentItemResult.ReadOnly =
    zio.aws.comprehend.model.BatchDetectSentimentItemResult
      .wrap(buildAwsValue())
}
object BatchDetectSentimentItemResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.BatchDetectSentimentItemResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.BatchDetectSentimentItemResult =
      zio.aws.comprehend.model.BatchDetectSentimentItemResult(
        index.map(value => value),
        sentiment.map(value => value),
        sentimentScore.map(value => value.asEditable)
      )
    def index: Optional[Integer]
    def sentiment: Optional[zio.aws.comprehend.model.SentimentType]
    def sentimentScore
        : Optional[zio.aws.comprehend.model.SentimentScore.ReadOnly]
    def getIndex: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("index", index)
    def getSentiment
        : ZIO[Any, AwsError, zio.aws.comprehend.model.SentimentType] =
      AwsError.unwrapOptionField("sentiment", sentiment)
    def getSentimentScore
        : ZIO[Any, AwsError, zio.aws.comprehend.model.SentimentScore.ReadOnly] =
      AwsError.unwrapOptionField("sentimentScore", sentimentScore)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.BatchDetectSentimentItemResult
  ) extends zio.aws.comprehend.model.BatchDetectSentimentItemResult.ReadOnly {
    override val index: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.index())
      .map(value => value: Integer)
    override val sentiment: Optional[zio.aws.comprehend.model.SentimentType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sentiment())
        .map(value => zio.aws.comprehend.model.SentimentType.wrap(value))
    override val sentimentScore
        : Optional[zio.aws.comprehend.model.SentimentScore.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sentimentScore())
        .map(value => zio.aws.comprehend.model.SentimentScore.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.BatchDetectSentimentItemResult
  ): zio.aws.comprehend.model.BatchDetectSentimentItemResult.ReadOnly =
    new Wrapper(impl)
}
