package zio.aws.comprehend.model
import scala.jdk.CollectionConverters.*
sealed trait DatasetType {
  def unwrap: software.amazon.awssdk.services.comprehend.model.DatasetType
}
object DatasetType {
  def wrap(
      value: software.amazon.awssdk.services.comprehend.model.DatasetType
  ): zio.aws.comprehend.model.DatasetType = value match {
    case software.amazon.awssdk.services.comprehend.model.DatasetType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.comprehend.model.DatasetType.TRAIN =>
      val r = TRAIN
      r
    case software.amazon.awssdk.services.comprehend.model.DatasetType.TEST =>
      val r = TEST
      r
  }
  case object unknownToSdkVersion extends zio.aws.comprehend.model.DatasetType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.DatasetType =
      software.amazon.awssdk.services.comprehend.model.DatasetType.UNKNOWN_TO_SDK_VERSION
  }
  case object TRAIN extends zio.aws.comprehend.model.DatasetType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.DatasetType =
      software.amazon.awssdk.services.comprehend.model.DatasetType.TRAIN
  }
  case object TEST extends zio.aws.comprehend.model.DatasetType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.DatasetType =
      software.amazon.awssdk.services.comprehend.model.DatasetType.TEST
  }
}
