package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.{
  ComprehendModelArn,
  ComprehendEndpointArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateEndpointResponse(
    endpointArn: Optional[ComprehendEndpointArn] = Optional.Absent,
    modelArn: Optional[ComprehendModelArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.CreateEndpointResponse = {
    import CreateEndpointResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.CreateEndpointResponse
      .builder()
      .optionallyWith(
        endpointArn.map(value =>
          ComprehendEndpointArn.unwrap(value): java.lang.String
        )
      )(_.endpointArn)
      .optionallyWith(
        modelArn.map(value =>
          ComprehendModelArn.unwrap(value): java.lang.String
        )
      )(_.modelArn)
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.CreateEndpointResponse.ReadOnly =
    zio.aws.comprehend.model.CreateEndpointResponse.wrap(buildAwsValue())
}
object CreateEndpointResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.CreateEndpointResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.CreateEndpointResponse =
      zio.aws.comprehend.model.CreateEndpointResponse(
        endpointArn.map(value => value),
        modelArn.map(value => value)
      )
    def endpointArn: Optional[ComprehendEndpointArn]
    def modelArn: Optional[ComprehendModelArn]
    def getEndpointArn: ZIO[Any, AwsError, ComprehendEndpointArn] =
      AwsError.unwrapOptionField("endpointArn", endpointArn)
    def getModelArn: ZIO[Any, AwsError, ComprehendModelArn] =
      AwsError.unwrapOptionField("modelArn", modelArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.CreateEndpointResponse
  ) extends zio.aws.comprehend.model.CreateEndpointResponse.ReadOnly {
    override val endpointArn: Optional[ComprehendEndpointArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endpointArn())
        .map(value =>
          zio.aws.comprehend.model.primitives.ComprehendEndpointArn(value)
        )
    override val modelArn: Optional[ComprehendModelArn] = zio.aws.core.internal
      .optionalFromNullable(impl.modelArn())
      .map(value =>
        zio.aws.comprehend.model.primitives.ComprehendModelArn(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.CreateEndpointResponse
  ): zio.aws.comprehend.model.CreateEndpointResponse.ReadOnly = new Wrapper(
    impl
  )
}
