package zio.aws.comprehend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListPiiEntitiesDetectionJobsResponse(
    piiEntitiesDetectionJobPropertiesList: Optional[
      Iterable[zio.aws.comprehend.model.PiiEntitiesDetectionJobProperties]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.ListPiiEntitiesDetectionJobsResponse = {
    import ListPiiEntitiesDetectionJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.ListPiiEntitiesDetectionJobsResponse
      .builder()
      .optionallyWith(
        piiEntitiesDetectionJobPropertiesList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.piiEntitiesDetectionJobPropertiesList)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.ListPiiEntitiesDetectionJobsResponse.ReadOnly =
    zio.aws.comprehend.model.ListPiiEntitiesDetectionJobsResponse
      .wrap(buildAwsValue())
}
object ListPiiEntitiesDetectionJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.ListPiiEntitiesDetectionJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.comprehend.model.ListPiiEntitiesDetectionJobsResponse =
      zio.aws.comprehend.model.ListPiiEntitiesDetectionJobsResponse(
        piiEntitiesDetectionJobPropertiesList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def piiEntitiesDetectionJobPropertiesList: Optional[
      List[zio.aws.comprehend.model.PiiEntitiesDetectionJobProperties.ReadOnly]
    ]
    def nextToken: Optional[String]
    def getPiiEntitiesDetectionJobPropertiesList: ZIO[Any, AwsError, List[
      zio.aws.comprehend.model.PiiEntitiesDetectionJobProperties.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "piiEntitiesDetectionJobPropertiesList",
      piiEntitiesDetectionJobPropertiesList
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.ListPiiEntitiesDetectionJobsResponse
  ) extends zio.aws.comprehend.model.ListPiiEntitiesDetectionJobsResponse.ReadOnly {
    override val piiEntitiesDetectionJobPropertiesList: Optional[
      List[zio.aws.comprehend.model.PiiEntitiesDetectionJobProperties.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.piiEntitiesDetectionJobPropertiesList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.comprehend.model.PiiEntitiesDetectionJobProperties.wrap(item)
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.ListPiiEntitiesDetectionJobsResponse
  ): zio.aws.comprehend.model.ListPiiEntitiesDetectionJobsResponse.ReadOnly =
    new Wrapper(impl)
}
