package zio.aws.comprehend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class FlywheelModelEvaluationMetrics(
    averageF1Score: Optional[Double] = Optional.Absent,
    averagePrecision: Optional[Double] = Optional.Absent,
    averageRecall: Optional[Double] = Optional.Absent,
    averageAccuracy: Optional[Double] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.FlywheelModelEvaluationMetrics = {
    import FlywheelModelEvaluationMetrics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.FlywheelModelEvaluationMetrics
      .builder()
      .optionallyWith(averageF1Score.map(value => value: java.lang.Double))(
        _.averageF1Score
      )
      .optionallyWith(averagePrecision.map(value => value: java.lang.Double))(
        _.averagePrecision
      )
      .optionallyWith(averageRecall.map(value => value: java.lang.Double))(
        _.averageRecall
      )
      .optionallyWith(averageAccuracy.map(value => value: java.lang.Double))(
        _.averageAccuracy
      )
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.FlywheelModelEvaluationMetrics.ReadOnly =
    zio.aws.comprehend.model.FlywheelModelEvaluationMetrics
      .wrap(buildAwsValue())
}
object FlywheelModelEvaluationMetrics {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.FlywheelModelEvaluationMetrics
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.FlywheelModelEvaluationMetrics =
      zio.aws.comprehend.model.FlywheelModelEvaluationMetrics(
        averageF1Score.map(value => value),
        averagePrecision.map(value => value),
        averageRecall.map(value => value),
        averageAccuracy.map(value => value)
      )
    def averageF1Score: Optional[Double]
    def averagePrecision: Optional[Double]
    def averageRecall: Optional[Double]
    def averageAccuracy: Optional[Double]
    def getAverageF1Score: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("averageF1Score", averageF1Score)
    def getAveragePrecision: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("averagePrecision", averagePrecision)
    def getAverageRecall: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("averageRecall", averageRecall)
    def getAverageAccuracy: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("averageAccuracy", averageAccuracy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.FlywheelModelEvaluationMetrics
  ) extends zio.aws.comprehend.model.FlywheelModelEvaluationMetrics.ReadOnly {
    override val averageF1Score: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.averageF1Score())
      .map(value => value: Double)
    override val averagePrecision: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.averagePrecision())
      .map(value => value: Double)
    override val averageRecall: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.averageRecall())
      .map(value => value: Double)
    override val averageAccuracy: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.averageAccuracy())
      .map(value => value: Double)
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.FlywheelModelEvaluationMetrics
  ): zio.aws.comprehend.model.FlywheelModelEvaluationMetrics.ReadOnly =
    new Wrapper(impl)
}
