package zio.aws.comprehend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeDatasetResponse(
    datasetProperties: Optional[zio.aws.comprehend.model.DatasetProperties] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.DescribeDatasetResponse = {
    import DescribeDatasetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.DescribeDatasetResponse
      .builder()
      .optionallyWith(datasetProperties.map(value => value.buildAwsValue()))(
        _.datasetProperties
      )
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.DescribeDatasetResponse.ReadOnly =
    zio.aws.comprehend.model.DescribeDatasetResponse.wrap(buildAwsValue())
}
object DescribeDatasetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.DescribeDatasetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.DescribeDatasetResponse =
      zio.aws.comprehend.model.DescribeDatasetResponse(
        datasetProperties.map(value => value.asEditable)
      )
    def datasetProperties
        : Optional[zio.aws.comprehend.model.DatasetProperties.ReadOnly]
    def getDatasetProperties: ZIO[
      Any,
      AwsError,
      zio.aws.comprehend.model.DatasetProperties.ReadOnly
    ] = AwsError.unwrapOptionField("datasetProperties", datasetProperties)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.DescribeDatasetResponse
  ) extends zio.aws.comprehend.model.DescribeDatasetResponse.ReadOnly {
    override val datasetProperties
        : Optional[zio.aws.comprehend.model.DatasetProperties.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.datasetProperties())
        .map(value => zio.aws.comprehend.model.DatasetProperties.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.DescribeDatasetResponse
  ): zio.aws.comprehend.model.DescribeDatasetResponse.ReadOnly = new Wrapper(
    impl
  )
}
