package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.{LabelDelimiter, S3Uri}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DatasetDocumentClassifierInputDataConfig(
    s3Uri: S3Uri,
    labelDelimiter: Optional[LabelDelimiter] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.DatasetDocumentClassifierInputDataConfig = {
    import DatasetDocumentClassifierInputDataConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.DatasetDocumentClassifierInputDataConfig
      .builder()
      .s3Uri(S3Uri.unwrap(s3Uri): java.lang.String)
      .optionallyWith(
        labelDelimiter.map(value =>
          LabelDelimiter.unwrap(value): java.lang.String
        )
      )(_.labelDelimiter)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.DatasetDocumentClassifierInputDataConfig.ReadOnly =
    zio.aws.comprehend.model.DatasetDocumentClassifierInputDataConfig
      .wrap(buildAwsValue())
}
object DatasetDocumentClassifierInputDataConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.DatasetDocumentClassifierInputDataConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.comprehend.model.DatasetDocumentClassifierInputDataConfig =
      zio.aws.comprehend.model.DatasetDocumentClassifierInputDataConfig(
        s3Uri,
        labelDelimiter.map(value => value)
      )
    def s3Uri: S3Uri
    def labelDelimiter: Optional[LabelDelimiter]
    def getS3Uri: ZIO[Any, Nothing, S3Uri] = ZIO.succeed(s3Uri)
    def getLabelDelimiter: ZIO[Any, AwsError, LabelDelimiter] =
      AwsError.unwrapOptionField("labelDelimiter", labelDelimiter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.DatasetDocumentClassifierInputDataConfig
  ) extends zio.aws.comprehend.model.DatasetDocumentClassifierInputDataConfig.ReadOnly {
    override val s3Uri: S3Uri =
      zio.aws.comprehend.model.primitives.S3Uri(impl.s3Uri())
    override val labelDelimiter: Optional[LabelDelimiter] =
      zio.aws.core.internal
        .optionalFromNullable(impl.labelDelimiter())
        .map(value => zio.aws.comprehend.model.primitives.LabelDelimiter(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.DatasetDocumentClassifierInputDataConfig
  ): zio.aws.comprehend.model.DatasetDocumentClassifierInputDataConfig.ReadOnly =
    new Wrapper(impl)
}
