package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.JobId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class StopDominantLanguageDetectionJobRequest(jobId: JobId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.StopDominantLanguageDetectionJobRequest = {
    import StopDominantLanguageDetectionJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.StopDominantLanguageDetectionJobRequest
      .builder()
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.StopDominantLanguageDetectionJobRequest.ReadOnly =
    zio.aws.comprehend.model.StopDominantLanguageDetectionJobRequest
      .wrap(buildAwsValue())
}
object StopDominantLanguageDetectionJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.StopDominantLanguageDetectionJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.comprehend.model.StopDominantLanguageDetectionJobRequest =
      zio.aws.comprehend.model.StopDominantLanguageDetectionJobRequest(jobId)
    def jobId: JobId
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.StopDominantLanguageDetectionJobRequest
  ) extends zio.aws.comprehend.model.StopDominantLanguageDetectionJobRequest.ReadOnly {
    override val jobId: JobId =
      zio.aws.comprehend.model.primitives.JobId(impl.jobId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.StopDominantLanguageDetectionJobRequest
  ): zio.aws.comprehend.model.StopDominantLanguageDetectionJobRequest.ReadOnly =
    new Wrapper(impl)
}
