package zio.aws.comprehend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListTopicsDetectionJobsResponse(
    topicsDetectionJobPropertiesList: Optional[
      Iterable[zio.aws.comprehend.model.TopicsDetectionJobProperties]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.ListTopicsDetectionJobsResponse = {
    import ListTopicsDetectionJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.ListTopicsDetectionJobsResponse
      .builder()
      .optionallyWith(
        topicsDetectionJobPropertiesList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.topicsDetectionJobPropertiesList)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.ListTopicsDetectionJobsResponse.ReadOnly =
    zio.aws.comprehend.model.ListTopicsDetectionJobsResponse
      .wrap(buildAwsValue())
}
object ListTopicsDetectionJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.ListTopicsDetectionJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.ListTopicsDetectionJobsResponse =
      zio.aws.comprehend.model.ListTopicsDetectionJobsResponse(
        topicsDetectionJobPropertiesList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def topicsDetectionJobPropertiesList: Optional[
      List[zio.aws.comprehend.model.TopicsDetectionJobProperties.ReadOnly]
    ]
    def nextToken: Optional[String]
    def getTopicsDetectionJobPropertiesList: ZIO[Any, AwsError, List[
      zio.aws.comprehend.model.TopicsDetectionJobProperties.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "topicsDetectionJobPropertiesList",
      topicsDetectionJobPropertiesList
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.ListTopicsDetectionJobsResponse
  ) extends zio.aws.comprehend.model.ListTopicsDetectionJobsResponse.ReadOnly {
    override val topicsDetectionJobPropertiesList: Optional[
      List[zio.aws.comprehend.model.TopicsDetectionJobProperties.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.topicsDetectionJobPropertiesList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.comprehend.model.TopicsDetectionJobProperties.wrap(item)
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.ListTopicsDetectionJobsResponse
  ): zio.aws.comprehend.model.ListTopicsDetectionJobsResponse.ReadOnly =
    new Wrapper(impl)
}
