package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DocumentClass(
    name: Optional[String] = Optional.Absent,
    score: Optional[Float] = Optional.Absent,
    page: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.DocumentClass = {
    import DocumentClass.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.DocumentClass
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(score.map(value => value: java.lang.Float))(_.score)
      .optionallyWith(page.map(value => value: java.lang.Integer))(_.page)
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.DocumentClass.ReadOnly =
    zio.aws.comprehend.model.DocumentClass.wrap(buildAwsValue())
}
object DocumentClass {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.DocumentClass
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.DocumentClass =
      zio.aws.comprehend.model.DocumentClass(
        name.map(value => value),
        score.map(value => value),
        page.map(value => value)
      )
    def name: Optional[String]
    def score: Optional[Float]
    def page: Optional[Integer]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getScore: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("score", score)
    def getPage: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("page", page)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.DocumentClass
  ) extends zio.aws.comprehend.model.DocumentClass.ReadOnly {
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val score: Optional[Float] = zio.aws.core.internal
      .optionalFromNullable(impl.score())
      .map(value => value: Float)
    override val page: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.page())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.DocumentClass
  ): zio.aws.comprehend.model.DocumentClass.ReadOnly = new Wrapper(impl)
}
