package zio.aws.comprehend.model
import scala.jdk.CollectionConverters.*
sealed trait DocumentClassifierMode {
  def unwrap
      : software.amazon.awssdk.services.comprehend.model.DocumentClassifierMode
}
object DocumentClassifierMode {
  def wrap(
      value: software.amazon.awssdk.services.comprehend.model.DocumentClassifierMode
  ): zio.aws.comprehend.model.DocumentClassifierMode = value match {
    case software.amazon.awssdk.services.comprehend.model.DocumentClassifierMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.comprehend.model.DocumentClassifierMode.MULTI_CLASS =>
      val r = MULTI_CLASS
      r
    case software.amazon.awssdk.services.comprehend.model.DocumentClassifierMode.MULTI_LABEL =>
      val r = MULTI_LABEL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.comprehend.model.DocumentClassifierMode {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.DocumentClassifierMode =
      software.amazon.awssdk.services.comprehend.model.DocumentClassifierMode.UNKNOWN_TO_SDK_VERSION
  }
  case object MULTI_CLASS
      extends zio.aws.comprehend.model.DocumentClassifierMode {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.DocumentClassifierMode =
      software.amazon.awssdk.services.comprehend.model.DocumentClassifierMode.MULTI_CLASS
  }
  case object MULTI_LABEL
      extends zio.aws.comprehend.model.DocumentClassifierMode {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.DocumentClassifierMode =
      software.amazon.awssdk.services.comprehend.model.DocumentClassifierMode.MULTI_LABEL
  }
}
