package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.ComprehendDatasetArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeDatasetRequest(datasetArn: ComprehendDatasetArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.DescribeDatasetRequest = {
    import DescribeDatasetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.DescribeDatasetRequest
      .builder()
      .datasetArn(ComprehendDatasetArn.unwrap(datasetArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.DescribeDatasetRequest.ReadOnly =
    zio.aws.comprehend.model.DescribeDatasetRequest.wrap(buildAwsValue())
}
object DescribeDatasetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.DescribeDatasetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.DescribeDatasetRequest =
      zio.aws.comprehend.model.DescribeDatasetRequest(datasetArn)
    def datasetArn: ComprehendDatasetArn
    def getDatasetArn: ZIO[Any, Nothing, ComprehendDatasetArn] =
      ZIO.succeed(datasetArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.DescribeDatasetRequest
  ) extends zio.aws.comprehend.model.DescribeDatasetRequest.ReadOnly {
    override val datasetArn: ComprehendDatasetArn =
      zio.aws.comprehend.model.primitives
        .ComprehendDatasetArn(impl.datasetArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.DescribeDatasetRequest
  ): zio.aws.comprehend.model.DescribeDatasetRequest.ReadOnly = new Wrapper(
    impl
  )
}
