package zio.aws.comprehend.model
import scala.jdk.CollectionConverters.*
sealed trait RelationshipType {
  def unwrap: software.amazon.awssdk.services.comprehend.model.RelationshipType
}
object RelationshipType {
  def wrap(
      value: software.amazon.awssdk.services.comprehend.model.RelationshipType
  ): zio.aws.comprehend.model.RelationshipType = value match {
    case software.amazon.awssdk.services.comprehend.model.RelationshipType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.comprehend.model.RelationshipType.CHILD =>
      val r = CHILD
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.comprehend.model.RelationshipType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.RelationshipType =
      software.amazon.awssdk.services.comprehend.model.RelationshipType.UNKNOWN_TO_SDK_VERSION
  }
  case object CHILD extends zio.aws.comprehend.model.RelationshipType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.RelationshipType =
      software.amazon.awssdk.services.comprehend.model.RelationshipType.CHILD
  }
}
