package zio.aws.comprehend.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.comprehend.model.primitives.{Timestamp, ComprehendArnName}
import scala.jdk.CollectionConverters.*
final case class EntityRecognizerFilter(
    status: Optional[zio.aws.comprehend.model.ModelStatus] = Optional.Absent,
    recognizerName: Optional[ComprehendArnName] = Optional.Absent,
    submitTimeBefore: Optional[Timestamp] = Optional.Absent,
    submitTimeAfter: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.EntityRecognizerFilter = {
    import EntityRecognizerFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.EntityRecognizerFilter
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        recognizerName.map(value =>
          ComprehendArnName.unwrap(value): java.lang.String
        )
      )(_.recognizerName)
      .optionallyWith(
        submitTimeBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.submitTimeBefore)
      .optionallyWith(
        submitTimeAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.submitTimeAfter)
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.EntityRecognizerFilter.ReadOnly =
    zio.aws.comprehend.model.EntityRecognizerFilter.wrap(buildAwsValue())
}
object EntityRecognizerFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.EntityRecognizerFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.EntityRecognizerFilter =
      zio.aws.comprehend.model.EntityRecognizerFilter(
        status.map(value => value),
        recognizerName.map(value => value),
        submitTimeBefore.map(value => value),
        submitTimeAfter.map(value => value)
      )
    def status: Optional[zio.aws.comprehend.model.ModelStatus]
    def recognizerName: Optional[ComprehendArnName]
    def submitTimeBefore: Optional[Timestamp]
    def submitTimeAfter: Optional[Timestamp]
    def getStatus: ZIO[Any, AwsError, zio.aws.comprehend.model.ModelStatus] =
      AwsError.unwrapOptionField("status", status)
    def getRecognizerName: ZIO[Any, AwsError, ComprehendArnName] =
      AwsError.unwrapOptionField("recognizerName", recognizerName)
    def getSubmitTimeBefore: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("submitTimeBefore", submitTimeBefore)
    def getSubmitTimeAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("submitTimeAfter", submitTimeAfter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.EntityRecognizerFilter
  ) extends zio.aws.comprehend.model.EntityRecognizerFilter.ReadOnly {
    override val status: Optional[zio.aws.comprehend.model.ModelStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.comprehend.model.ModelStatus.wrap(value))
    override val recognizerName: Optional[ComprehendArnName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recognizerName())
        .map(value =>
          zio.aws.comprehend.model.primitives.ComprehendArnName(value)
        )
    override val submitTimeBefore: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.submitTimeBefore())
      .map(value => zio.aws.comprehend.model.primitives.Timestamp(value))
    override val submitTimeAfter: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.submitTimeAfter())
      .map(value => zio.aws.comprehend.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.EntityRecognizerFilter
  ): zio.aws.comprehend.model.EntityRecognizerFilter.ReadOnly = new Wrapper(
    impl
  )
}
