package zio.aws.comprehend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ClassifyDocumentResponse(
    classes: Optional[Iterable[zio.aws.comprehend.model.DocumentClass]] =
      Optional.Absent,
    labels: Optional[Iterable[zio.aws.comprehend.model.DocumentLabel]] =
      Optional.Absent,
    documentMetadata: Optional[zio.aws.comprehend.model.DocumentMetadata] =
      Optional.Absent,
    documentType: Optional[
      Iterable[zio.aws.comprehend.model.DocumentTypeListItem]
    ] = Optional.Absent,
    errors: Optional[Iterable[zio.aws.comprehend.model.ErrorsListItem]] =
      Optional.Absent,
    warnings: Optional[Iterable[zio.aws.comprehend.model.WarningsListItem]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.ClassifyDocumentResponse = {
    import ClassifyDocumentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.ClassifyDocumentResponse
      .builder()
      .optionallyWith(
        classes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.classes)
      .optionallyWith(
        labels.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.labels)
      .optionallyWith(documentMetadata.map(value => value.buildAwsValue()))(
        _.documentMetadata
      )
      .optionallyWith(
        documentType.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.documentType)
      .optionallyWith(
        errors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.errors)
      .optionallyWith(
        warnings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.warnings)
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.ClassifyDocumentResponse.ReadOnly =
    zio.aws.comprehend.model.ClassifyDocumentResponse.wrap(buildAwsValue())
}
object ClassifyDocumentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.ClassifyDocumentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.ClassifyDocumentResponse =
      zio.aws.comprehend.model.ClassifyDocumentResponse(
        classes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        labels.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        documentMetadata.map(value => value.asEditable),
        documentType.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        errors.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        warnings.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def classes: Optional[List[zio.aws.comprehend.model.DocumentClass.ReadOnly]]
    def labels: Optional[List[zio.aws.comprehend.model.DocumentLabel.ReadOnly]]
    def documentMetadata
        : Optional[zio.aws.comprehend.model.DocumentMetadata.ReadOnly]
    def documentType
        : Optional[List[zio.aws.comprehend.model.DocumentTypeListItem.ReadOnly]]
    def errors: Optional[List[zio.aws.comprehend.model.ErrorsListItem.ReadOnly]]
    def warnings
        : Optional[List[zio.aws.comprehend.model.WarningsListItem.ReadOnly]]
    def getClasses: ZIO[Any, AwsError, List[
      zio.aws.comprehend.model.DocumentClass.ReadOnly
    ]] = AwsError.unwrapOptionField("classes", classes)
    def getLabels: ZIO[Any, AwsError, List[
      zio.aws.comprehend.model.DocumentLabel.ReadOnly
    ]] = AwsError.unwrapOptionField("labels", labels)
    def getDocumentMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.comprehend.model.DocumentMetadata.ReadOnly
    ] = AwsError.unwrapOptionField("documentMetadata", documentMetadata)
    def getDocumentType: ZIO[Any, AwsError, List[
      zio.aws.comprehend.model.DocumentTypeListItem.ReadOnly
    ]] = AwsError.unwrapOptionField("documentType", documentType)
    def getErrors: ZIO[Any, AwsError, List[
      zio.aws.comprehend.model.ErrorsListItem.ReadOnly
    ]] = AwsError.unwrapOptionField("errors", errors)
    def getWarnings: ZIO[Any, AwsError, List[
      zio.aws.comprehend.model.WarningsListItem.ReadOnly
    ]] = AwsError.unwrapOptionField("warnings", warnings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.ClassifyDocumentResponse
  ) extends zio.aws.comprehend.model.ClassifyDocumentResponse.ReadOnly {
    override val classes
        : Optional[List[zio.aws.comprehend.model.DocumentClass.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.classes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.comprehend.model.DocumentClass.wrap(item)
          }.toList
        )
    override val labels
        : Optional[List[zio.aws.comprehend.model.DocumentLabel.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.labels())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.comprehend.model.DocumentLabel.wrap(item)
          }.toList
        )
    override val documentMetadata
        : Optional[zio.aws.comprehend.model.DocumentMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentMetadata())
        .map(value => zio.aws.comprehend.model.DocumentMetadata.wrap(value))
    override val documentType: Optional[
      List[zio.aws.comprehend.model.DocumentTypeListItem.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.documentType())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.comprehend.model.DocumentTypeListItem.wrap(item)
        }.toList
      )
    override val errors
        : Optional[List[zio.aws.comprehend.model.ErrorsListItem.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.comprehend.model.ErrorsListItem.wrap(item)
          }.toList
        )
    override val warnings
        : Optional[List[zio.aws.comprehend.model.WarningsListItem.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.warnings())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.comprehend.model.WarningsListItem.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.ClassifyDocumentResponse
  ): zio.aws.comprehend.model.ClassifyDocumentResponse.ReadOnly = new Wrapper(
    impl
  )
}
