package zio.aws.comprehend.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.comprehend.model.primitives.MaxResultsInteger
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListEntityRecognizerSummariesRequest(
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[MaxResultsInteger] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.ListEntityRecognizerSummariesRequest = {
    import ListEntityRecognizerSummariesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.ListEntityRecognizerSummariesRequest
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => MaxResultsInteger.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.ListEntityRecognizerSummariesRequest.ReadOnly =
    zio.aws.comprehend.model.ListEntityRecognizerSummariesRequest
      .wrap(buildAwsValue())
}
object ListEntityRecognizerSummariesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.ListEntityRecognizerSummariesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.comprehend.model.ListEntityRecognizerSummariesRequest =
      zio.aws.comprehend.model.ListEntityRecognizerSummariesRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Optional[String]
    def maxResults: Optional[MaxResultsInteger]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.ListEntityRecognizerSummariesRequest
  ) extends zio.aws.comprehend.model.ListEntityRecognizerSummariesRequest.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[MaxResultsInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value =>
        zio.aws.comprehend.model.primitives.MaxResultsInteger(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.ListEntityRecognizerSummariesRequest
  ): zio.aws.comprehend.model.ListEntityRecognizerSummariesRequest.ReadOnly =
    new Wrapper(impl)
}
