package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.S3Uri
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class EntityRecognizerDocuments(
    s3Uri: S3Uri,
    testS3Uri: Optional[S3Uri] = Optional.Absent,
    inputFormat: Optional[zio.aws.comprehend.model.InputFormat] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.EntityRecognizerDocuments = {
    import EntityRecognizerDocuments.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.EntityRecognizerDocuments
      .builder()
      .s3Uri(S3Uri.unwrap(s3Uri): java.lang.String)
      .optionallyWith(
        testS3Uri.map(value => S3Uri.unwrap(value): java.lang.String)
      )(_.testS3Uri)
      .optionallyWith(inputFormat.map(value => value.unwrap))(_.inputFormat)
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.EntityRecognizerDocuments.ReadOnly =
    zio.aws.comprehend.model.EntityRecognizerDocuments.wrap(buildAwsValue())
}
object EntityRecognizerDocuments {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.EntityRecognizerDocuments
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.EntityRecognizerDocuments =
      zio.aws.comprehend.model.EntityRecognizerDocuments(
        s3Uri,
        testS3Uri.map(value => value),
        inputFormat.map(value => value)
      )
    def s3Uri: S3Uri
    def testS3Uri: Optional[S3Uri]
    def inputFormat: Optional[zio.aws.comprehend.model.InputFormat]
    def getS3Uri: ZIO[Any, Nothing, S3Uri] = ZIO.succeed(s3Uri)
    def getTestS3Uri: ZIO[Any, AwsError, S3Uri] =
      AwsError.unwrapOptionField("testS3Uri", testS3Uri)
    def getInputFormat
        : ZIO[Any, AwsError, zio.aws.comprehend.model.InputFormat] =
      AwsError.unwrapOptionField("inputFormat", inputFormat)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.EntityRecognizerDocuments
  ) extends zio.aws.comprehend.model.EntityRecognizerDocuments.ReadOnly {
    override val s3Uri: S3Uri =
      zio.aws.comprehend.model.primitives.S3Uri(impl.s3Uri())
    override val testS3Uri: Optional[S3Uri] = zio.aws.core.internal
      .optionalFromNullable(impl.testS3Uri())
      .map(value => zio.aws.comprehend.model.primitives.S3Uri(value))
    override val inputFormat: Optional[zio.aws.comprehend.model.InputFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inputFormat())
        .map(value => zio.aws.comprehend.model.InputFormat.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.EntityRecognizerDocuments
  ): zio.aws.comprehend.model.EntityRecognizerDocuments.ReadOnly = new Wrapper(
    impl
  )
}
