package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.S3Uri
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DatasetEntityRecognizerDocuments(
    s3Uri: S3Uri,
    inputFormat: Optional[zio.aws.comprehend.model.InputFormat] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.DatasetEntityRecognizerDocuments = {
    import DatasetEntityRecognizerDocuments.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.DatasetEntityRecognizerDocuments
      .builder()
      .s3Uri(S3Uri.unwrap(s3Uri): java.lang.String)
      .optionallyWith(inputFormat.map(value => value.unwrap))(_.inputFormat)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.DatasetEntityRecognizerDocuments.ReadOnly =
    zio.aws.comprehend.model.DatasetEntityRecognizerDocuments
      .wrap(buildAwsValue())
}
object DatasetEntityRecognizerDocuments {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.DatasetEntityRecognizerDocuments
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.DatasetEntityRecognizerDocuments =
      zio.aws.comprehend.model.DatasetEntityRecognizerDocuments(
        s3Uri,
        inputFormat.map(value => value)
      )
    def s3Uri: S3Uri
    def inputFormat: Optional[zio.aws.comprehend.model.InputFormat]
    def getS3Uri: ZIO[Any, Nothing, S3Uri] = ZIO.succeed(s3Uri)
    def getInputFormat
        : ZIO[Any, AwsError, zio.aws.comprehend.model.InputFormat] =
      AwsError.unwrapOptionField("inputFormat", inputFormat)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.DatasetEntityRecognizerDocuments
  ) extends zio.aws.comprehend.model.DatasetEntityRecognizerDocuments.ReadOnly {
    override val s3Uri: S3Uri =
      zio.aws.comprehend.model.primitives.S3Uri(impl.s3Uri())
    override val inputFormat: Optional[zio.aws.comprehend.model.InputFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inputFormat())
        .map(value => zio.aws.comprehend.model.InputFormat.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.DatasetEntityRecognizerDocuments
  ): zio.aws.comprehend.model.DatasetEntityRecognizerDocuments.ReadOnly =
    new Wrapper(impl)
}
