package zio.aws.comprehend.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.comprehend.model.primitives.{
  ComprehendFlywheelArn,
  IamRoleArn,
  ComprehendModelArn,
  ComprehendEndpointArn,
  InferenceUnitsInteger
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class UpdateEndpointRequest(
    endpointArn: ComprehendEndpointArn,
    desiredModelArn: Optional[ComprehendModelArn] = Optional.Absent,
    desiredInferenceUnits: Optional[InferenceUnitsInteger] = Optional.Absent,
    desiredDataAccessRoleArn: Optional[IamRoleArn] = Optional.Absent,
    flywheelArn: Optional[ComprehendFlywheelArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.UpdateEndpointRequest = {
    import UpdateEndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.UpdateEndpointRequest
      .builder()
      .endpointArn(ComprehendEndpointArn.unwrap(endpointArn): java.lang.String)
      .optionallyWith(
        desiredModelArn.map(value =>
          ComprehendModelArn.unwrap(value): java.lang.String
        )
      )(_.desiredModelArn)
      .optionallyWith(
        desiredInferenceUnits.map(value =>
          InferenceUnitsInteger.unwrap(value): Integer
        )
      )(_.desiredInferenceUnits)
      .optionallyWith(
        desiredDataAccessRoleArn.map(value =>
          IamRoleArn.unwrap(value): java.lang.String
        )
      )(_.desiredDataAccessRoleArn)
      .optionallyWith(
        flywheelArn.map(value =>
          ComprehendFlywheelArn.unwrap(value): java.lang.String
        )
      )(_.flywheelArn)
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.UpdateEndpointRequest.ReadOnly =
    zio.aws.comprehend.model.UpdateEndpointRequest.wrap(buildAwsValue())
}
object UpdateEndpointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.UpdateEndpointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.UpdateEndpointRequest =
      zio.aws.comprehend.model.UpdateEndpointRequest(
        endpointArn,
        desiredModelArn.map(value => value),
        desiredInferenceUnits.map(value => value),
        desiredDataAccessRoleArn.map(value => value),
        flywheelArn.map(value => value)
      )
    def endpointArn: ComprehendEndpointArn
    def desiredModelArn: Optional[ComprehendModelArn]
    def desiredInferenceUnits: Optional[InferenceUnitsInteger]
    def desiredDataAccessRoleArn: Optional[IamRoleArn]
    def flywheelArn: Optional[ComprehendFlywheelArn]
    def getEndpointArn: ZIO[Any, Nothing, ComprehendEndpointArn] =
      ZIO.succeed(endpointArn)
    def getDesiredModelArn: ZIO[Any, AwsError, ComprehendModelArn] =
      AwsError.unwrapOptionField("desiredModelArn", desiredModelArn)
    def getDesiredInferenceUnits: ZIO[Any, AwsError, InferenceUnitsInteger] =
      AwsError.unwrapOptionField("desiredInferenceUnits", desiredInferenceUnits)
    def getDesiredDataAccessRoleArn: ZIO[Any, AwsError, IamRoleArn] = AwsError
      .unwrapOptionField("desiredDataAccessRoleArn", desiredDataAccessRoleArn)
    def getFlywheelArn: ZIO[Any, AwsError, ComprehendFlywheelArn] =
      AwsError.unwrapOptionField("flywheelArn", flywheelArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.UpdateEndpointRequest
  ) extends zio.aws.comprehend.model.UpdateEndpointRequest.ReadOnly {
    override val endpointArn: ComprehendEndpointArn =
      zio.aws.comprehend.model.primitives
        .ComprehendEndpointArn(impl.endpointArn())
    override val desiredModelArn: Optional[ComprehendModelArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.desiredModelArn())
        .map(value =>
          zio.aws.comprehend.model.primitives.ComprehendModelArn(value)
        )
    override val desiredInferenceUnits: Optional[InferenceUnitsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.desiredInferenceUnits())
        .map(value =>
          zio.aws.comprehend.model.primitives.InferenceUnitsInteger(value)
        )
    override val desiredDataAccessRoleArn: Optional[IamRoleArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.desiredDataAccessRoleArn())
        .map(value => zio.aws.comprehend.model.primitives.IamRoleArn(value))
    override val flywheelArn: Optional[ComprehendFlywheelArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.flywheelArn())
        .map(value =>
          zio.aws.comprehend.model.primitives.ComprehendFlywheelArn(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.UpdateEndpointRequest
  ): zio.aws.comprehend.model.UpdateEndpointRequest.ReadOnly = new Wrapper(impl)
}
