package zio.aws.comprehend.model
import scala.jdk.CollectionConverters.*
sealed trait PiiEntitiesDetectionMaskMode {
  def unwrap: software.amazon.awssdk.services.comprehend.model.PiiEntitiesDetectionMaskMode
}
object PiiEntitiesDetectionMaskMode {
  def wrap(
      value: software.amazon.awssdk.services.comprehend.model.PiiEntitiesDetectionMaskMode
  ): zio.aws.comprehend.model.PiiEntitiesDetectionMaskMode = value match {
    case software.amazon.awssdk.services.comprehend.model.PiiEntitiesDetectionMaskMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.comprehend.model.PiiEntitiesDetectionMaskMode.MASK =>
      val r = MASK
      r
    case software.amazon.awssdk.services.comprehend.model.PiiEntitiesDetectionMaskMode.REPLACE_WITH_PII_ENTITY_TYPE =>
      val r = REPLACE_WITH_PII_ENTITY_TYPE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.comprehend.model.PiiEntitiesDetectionMaskMode {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.PiiEntitiesDetectionMaskMode =
      software.amazon.awssdk.services.comprehend.model.PiiEntitiesDetectionMaskMode.UNKNOWN_TO_SDK_VERSION
  }
  case object MASK
      extends zio.aws.comprehend.model.PiiEntitiesDetectionMaskMode {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.PiiEntitiesDetectionMaskMode =
      software.amazon.awssdk.services.comprehend.model.PiiEntitiesDetectionMaskMode.MASK
  }
  case object REPLACE_WITH_PII_ENTITY_TYPE
      extends zio.aws.comprehend.model.PiiEntitiesDetectionMaskMode {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.PiiEntitiesDetectionMaskMode =
      software.amazon.awssdk.services.comprehend.model.PiiEntitiesDetectionMaskMode.REPLACE_WITH_PII_ENTITY_TYPE
  }
}
