package zio.aws.comprehend.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.comprehend.model.primitives.Timestamp
import scala.jdk.CollectionConverters.*
final case class FlywheelIterationFilter(
    creationTimeAfter: Optional[Timestamp] = Optional.Absent,
    creationTimeBefore: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.FlywheelIterationFilter = {
    import FlywheelIterationFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.FlywheelIterationFilter
      .builder()
      .optionallyWith(
        creationTimeAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTimeAfter)
      .optionallyWith(
        creationTimeBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTimeBefore)
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.FlywheelIterationFilter.ReadOnly =
    zio.aws.comprehend.model.FlywheelIterationFilter.wrap(buildAwsValue())
}
object FlywheelIterationFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.FlywheelIterationFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.FlywheelIterationFilter =
      zio.aws.comprehend.model.FlywheelIterationFilter(
        creationTimeAfter.map(value => value),
        creationTimeBefore.map(value => value)
      )
    def creationTimeAfter: Optional[Timestamp]
    def creationTimeBefore: Optional[Timestamp]
    def getCreationTimeAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTimeAfter", creationTimeAfter)
    def getCreationTimeBefore: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTimeBefore", creationTimeBefore)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.FlywheelIterationFilter
  ) extends zio.aws.comprehend.model.FlywheelIterationFilter.ReadOnly {
    override val creationTimeAfter: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTimeAfter())
      .map(value => zio.aws.comprehend.model.primitives.Timestamp(value))
    override val creationTimeBefore: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTimeBefore())
      .map(value => zio.aws.comprehend.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.FlywheelIterationFilter
  ): zio.aws.comprehend.model.FlywheelIterationFilter.ReadOnly = new Wrapper(
    impl
  )
}
