package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.CustomerInputString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DetectDominantLanguageRequest(text: CustomerInputString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.DetectDominantLanguageRequest = {
    import DetectDominantLanguageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.DetectDominantLanguageRequest
      .builder()
      .text(CustomerInputString.unwrap(text): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.DetectDominantLanguageRequest.ReadOnly =
    zio.aws.comprehend.model.DetectDominantLanguageRequest.wrap(buildAwsValue())
}
object DetectDominantLanguageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.DetectDominantLanguageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.DetectDominantLanguageRequest =
      zio.aws.comprehend.model.DetectDominantLanguageRequest(text)
    def text: CustomerInputString
    def getText: ZIO[Any, Nothing, CustomerInputString] = ZIO.succeed(text)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.DetectDominantLanguageRequest
  ) extends zio.aws.comprehend.model.DetectDominantLanguageRequest.ReadOnly {
    override val text: CustomerInputString =
      zio.aws.comprehend.model.primitives.CustomerInputString(impl.text())
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.DetectDominantLanguageRequest
  ): zio.aws.comprehend.model.DetectDominantLanguageRequest.ReadOnly =
    new Wrapper(impl)
}
