package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BatchItemError(
    index: Optional[Integer] = Optional.Absent,
    errorCode: Optional[String] = Optional.Absent,
    errorMessage: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.BatchItemError = {
    import BatchItemError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.BatchItemError
      .builder()
      .optionallyWith(index.map(value => value: java.lang.Integer))(_.index)
      .optionallyWith(errorCode.map(value => value: java.lang.String))(
        _.errorCode
      )
      .optionallyWith(errorMessage.map(value => value: java.lang.String))(
        _.errorMessage
      )
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.BatchItemError.ReadOnly =
    zio.aws.comprehend.model.BatchItemError.wrap(buildAwsValue())
}
object BatchItemError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.BatchItemError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.BatchItemError =
      zio.aws.comprehend.model.BatchItemError(
        index.map(value => value),
        errorCode.map(value => value),
        errorMessage.map(value => value)
      )
    def index: Optional[Integer]
    def errorCode: Optional[String]
    def errorMessage: Optional[String]
    def getIndex: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("index", index)
    def getErrorCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.BatchItemError
  ) extends zio.aws.comprehend.model.BatchItemError.ReadOnly {
    override val index: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.index())
      .map(value => value: Integer)
    override val errorCode: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.errorCode())
      .map(value => value: String)
    override val errorMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.BatchItemError
  ): zio.aws.comprehend.model.BatchItemError.ReadOnly = new Wrapper(impl)
}
