package zio.aws.comprehend.model
import scala.jdk.CollectionConverters.*
sealed trait Split {
  def unwrap: software.amazon.awssdk.services.comprehend.model.Split
}
object Split {
  def wrap(
      value: software.amazon.awssdk.services.comprehend.model.Split
  ): zio.aws.comprehend.model.Split = value match {
    case software.amazon.awssdk.services.comprehend.model.Split.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.comprehend.model.Split.TRAIN =>
      val r = TRAIN
      r
    case software.amazon.awssdk.services.comprehend.model.Split.TEST =>
      val r = TEST
      r
  }
  case object unknownToSdkVersion extends zio.aws.comprehend.model.Split {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.Split =
      software.amazon.awssdk.services.comprehend.model.Split.UNKNOWN_TO_SDK_VERSION
  }
  case object TRAIN extends zio.aws.comprehend.model.Split {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.Split =
      software.amazon.awssdk.services.comprehend.model.Split.TRAIN
  }
  case object TEST extends zio.aws.comprehend.model.Split {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.Split =
      software.amazon.awssdk.services.comprehend.model.Split.TEST
  }
}
