package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class TargetedSentimentEntity(
    descriptiveMentionIndex: Optional[Iterable[Integer]] = Optional.Absent,
    mentions: Optional[
      Iterable[zio.aws.comprehend.model.TargetedSentimentMention]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.TargetedSentimentEntity = {
    import TargetedSentimentEntity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.TargetedSentimentEntity
      .builder()
      .optionallyWith(
        descriptiveMentionIndex.map(value =>
          value.map { item =>
            item: java.lang.Integer
          }.asJavaCollection
        )
      )(_.descriptiveMentionIndex)
      .optionallyWith(
        mentions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.mentions)
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.TargetedSentimentEntity.ReadOnly =
    zio.aws.comprehend.model.TargetedSentimentEntity.wrap(buildAwsValue())
}
object TargetedSentimentEntity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.TargetedSentimentEntity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.TargetedSentimentEntity =
      zio.aws.comprehend.model.TargetedSentimentEntity(
        descriptiveMentionIndex.map(value => value),
        mentions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def descriptiveMentionIndex: Optional[List[Integer]]
    def mentions: Optional[
      List[zio.aws.comprehend.model.TargetedSentimentMention.ReadOnly]
    ]
    def getDescriptiveMentionIndex: ZIO[Any, AwsError, List[Integer]] = AwsError
      .unwrapOptionField("descriptiveMentionIndex", descriptiveMentionIndex)
    def getMentions: ZIO[Any, AwsError, List[
      zio.aws.comprehend.model.TargetedSentimentMention.ReadOnly
    ]] = AwsError.unwrapOptionField("mentions", mentions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.TargetedSentimentEntity
  ) extends zio.aws.comprehend.model.TargetedSentimentEntity.ReadOnly {
    override val descriptiveMentionIndex: Optional[List[Integer]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.descriptiveMentionIndex())
        .map(value =>
          value.asScala.map { item =>
            item: Integer
          }.toList
        )
    override val mentions: Optional[
      List[zio.aws.comprehend.model.TargetedSentimentMention.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.mentions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.comprehend.model.TargetedSentimentMention.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.TargetedSentimentEntity
  ): zio.aws.comprehend.model.TargetedSentimentEntity.ReadOnly = new Wrapper(
    impl
  )
}
