package zio.aws.comprehend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListKeyPhrasesDetectionJobsResponse(
    keyPhrasesDetectionJobPropertiesList: Optional[
      Iterable[zio.aws.comprehend.model.KeyPhrasesDetectionJobProperties]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.ListKeyPhrasesDetectionJobsResponse = {
    import ListKeyPhrasesDetectionJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.ListKeyPhrasesDetectionJobsResponse
      .builder()
      .optionallyWith(
        keyPhrasesDetectionJobPropertiesList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.keyPhrasesDetectionJobPropertiesList)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.ListKeyPhrasesDetectionJobsResponse.ReadOnly =
    zio.aws.comprehend.model.ListKeyPhrasesDetectionJobsResponse
      .wrap(buildAwsValue())
}
object ListKeyPhrasesDetectionJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.ListKeyPhrasesDetectionJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.comprehend.model.ListKeyPhrasesDetectionJobsResponse =
      zio.aws.comprehend.model.ListKeyPhrasesDetectionJobsResponse(
        keyPhrasesDetectionJobPropertiesList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def keyPhrasesDetectionJobPropertiesList: Optional[
      List[zio.aws.comprehend.model.KeyPhrasesDetectionJobProperties.ReadOnly]
    ]
    def nextToken: Optional[String]
    def getKeyPhrasesDetectionJobPropertiesList: ZIO[Any, AwsError, List[
      zio.aws.comprehend.model.KeyPhrasesDetectionJobProperties.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "keyPhrasesDetectionJobPropertiesList",
      keyPhrasesDetectionJobPropertiesList
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.ListKeyPhrasesDetectionJobsResponse
  ) extends zio.aws.comprehend.model.ListKeyPhrasesDetectionJobsResponse.ReadOnly {
    override val keyPhrasesDetectionJobPropertiesList: Optional[
      List[zio.aws.comprehend.model.KeyPhrasesDetectionJobProperties.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.keyPhrasesDetectionJobPropertiesList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.comprehend.model.KeyPhrasesDetectionJobProperties.wrap(item)
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.ListKeyPhrasesDetectionJobsResponse
  ): zio.aws.comprehend.model.ListKeyPhrasesDetectionJobsResponse.ReadOnly =
    new Wrapper(impl)
}
