package zio.aws.comprehend.model
import scala.jdk.CollectionConverters.*
sealed trait PageBasedErrorCode {
  def unwrap
      : software.amazon.awssdk.services.comprehend.model.PageBasedErrorCode
}
object PageBasedErrorCode {
  def wrap(
      value: software.amazon.awssdk.services.comprehend.model.PageBasedErrorCode
  ): zio.aws.comprehend.model.PageBasedErrorCode = value match {
    case software.amazon.awssdk.services.comprehend.model.PageBasedErrorCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.comprehend.model.PageBasedErrorCode.TEXTRACT_BAD_PAGE =>
      val r = TEXTRACT_BAD_PAGE
      r
    case software.amazon.awssdk.services.comprehend.model.PageBasedErrorCode.TEXTRACT_PROVISIONED_THROUGHPUT_EXCEEDED =>
      val r = TEXTRACT_PROVISIONED_THROUGHPUT_EXCEEDED
      r
    case software.amazon.awssdk.services.comprehend.model.PageBasedErrorCode.PAGE_CHARACTERS_EXCEEDED =>
      val r = PAGE_CHARACTERS_EXCEEDED
      r
    case software.amazon.awssdk.services.comprehend.model.PageBasedErrorCode.PAGE_SIZE_EXCEEDED =>
      val r = PAGE_SIZE_EXCEEDED
      r
    case software.amazon.awssdk.services.comprehend.model.PageBasedErrorCode.INTERNAL_SERVER_ERROR =>
      val r = INTERNAL_SERVER_ERROR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.comprehend.model.PageBasedErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.PageBasedErrorCode =
      software.amazon.awssdk.services.comprehend.model.PageBasedErrorCode.UNKNOWN_TO_SDK_VERSION
  }
  case object TEXTRACT_BAD_PAGE
      extends zio.aws.comprehend.model.PageBasedErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.PageBasedErrorCode =
      software.amazon.awssdk.services.comprehend.model.PageBasedErrorCode.TEXTRACT_BAD_PAGE
  }
  case object TEXTRACT_PROVISIONED_THROUGHPUT_EXCEEDED
      extends zio.aws.comprehend.model.PageBasedErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.PageBasedErrorCode =
      software.amazon.awssdk.services.comprehend.model.PageBasedErrorCode.TEXTRACT_PROVISIONED_THROUGHPUT_EXCEEDED
  }
  case object PAGE_CHARACTERS_EXCEEDED
      extends zio.aws.comprehend.model.PageBasedErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.PageBasedErrorCode =
      software.amazon.awssdk.services.comprehend.model.PageBasedErrorCode.PAGE_CHARACTERS_EXCEEDED
  }
  case object PAGE_SIZE_EXCEEDED
      extends zio.aws.comprehend.model.PageBasedErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.PageBasedErrorCode =
      software.amazon.awssdk.services.comprehend.model.PageBasedErrorCode.PAGE_SIZE_EXCEEDED
  }
  case object INTERNAL_SERVER_ERROR
      extends zio.aws.comprehend.model.PageBasedErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.PageBasedErrorCode =
      software.amazon.awssdk.services.comprehend.model.PageBasedErrorCode.INTERNAL_SERVER_ERROR
  }
}
