package zio.aws.comprehend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListFlywheelIterationHistoryResponse(
    flywheelIterationPropertiesList: Optional[
      Iterable[zio.aws.comprehend.model.FlywheelIterationProperties]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.ListFlywheelIterationHistoryResponse = {
    import ListFlywheelIterationHistoryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.ListFlywheelIterationHistoryResponse
      .builder()
      .optionallyWith(
        flywheelIterationPropertiesList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.flywheelIterationPropertiesList)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.ListFlywheelIterationHistoryResponse.ReadOnly =
    zio.aws.comprehend.model.ListFlywheelIterationHistoryResponse
      .wrap(buildAwsValue())
}
object ListFlywheelIterationHistoryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.ListFlywheelIterationHistoryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.comprehend.model.ListFlywheelIterationHistoryResponse =
      zio.aws.comprehend.model.ListFlywheelIterationHistoryResponse(
        flywheelIterationPropertiesList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def flywheelIterationPropertiesList: Optional[
      List[zio.aws.comprehend.model.FlywheelIterationProperties.ReadOnly]
    ]
    def nextToken: Optional[String]
    def getFlywheelIterationPropertiesList: ZIO[Any, AwsError, List[
      zio.aws.comprehend.model.FlywheelIterationProperties.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "flywheelIterationPropertiesList",
      flywheelIterationPropertiesList
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.ListFlywheelIterationHistoryResponse
  ) extends zio.aws.comprehend.model.ListFlywheelIterationHistoryResponse.ReadOnly {
    override val flywheelIterationPropertiesList: Optional[
      List[zio.aws.comprehend.model.FlywheelIterationProperties.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.flywheelIterationPropertiesList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.comprehend.model.FlywheelIterationProperties.wrap(item)
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.ListFlywheelIterationHistoryResponse
  ): zio.aws.comprehend.model.ListFlywheelIterationHistoryResponse.ReadOnly =
    new Wrapper(impl)
}
