package zio.aws.comprehend.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.comprehend.model.primitives.{
  ComprehendFlywheelArn,
  IamRoleArn,
  ComprehendModelArn,
  AnyLengthString,
  S3Uri,
  Timestamp,
  FlywheelIterationId
}
import scala.jdk.CollectionConverters.*
final case class FlywheelProperties(
    flywheelArn: Optional[ComprehendFlywheelArn] = Optional.Absent,
    activeModelArn: Optional[ComprehendModelArn] = Optional.Absent,
    dataAccessRoleArn: Optional[IamRoleArn] = Optional.Absent,
    taskConfig: Optional[zio.aws.comprehend.model.TaskConfig] = Optional.Absent,
    dataLakeS3Uri: Optional[S3Uri] = Optional.Absent,
    dataSecurityConfig: Optional[zio.aws.comprehend.model.DataSecurityConfig] =
      Optional.Absent,
    status: Optional[zio.aws.comprehend.model.FlywheelStatus] = Optional.Absent,
    modelType: Optional[zio.aws.comprehend.model.ModelType] = Optional.Absent,
    message: Optional[AnyLengthString] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    lastModifiedTime: Optional[Timestamp] = Optional.Absent,
    latestFlywheelIteration: Optional[FlywheelIterationId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.FlywheelProperties = {
    import FlywheelProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.FlywheelProperties
      .builder()
      .optionallyWith(
        flywheelArn.map(value =>
          ComprehendFlywheelArn.unwrap(value): java.lang.String
        )
      )(_.flywheelArn)
      .optionallyWith(
        activeModelArn.map(value =>
          ComprehendModelArn.unwrap(value): java.lang.String
        )
      )(_.activeModelArn)
      .optionallyWith(
        dataAccessRoleArn.map(value =>
          IamRoleArn.unwrap(value): java.lang.String
        )
      )(_.dataAccessRoleArn)
      .optionallyWith(taskConfig.map(value => value.buildAwsValue()))(
        _.taskConfig
      )
      .optionallyWith(
        dataLakeS3Uri.map(value => S3Uri.unwrap(value): java.lang.String)
      )(_.dataLakeS3Uri)
      .optionallyWith(dataSecurityConfig.map(value => value.buildAwsValue()))(
        _.dataSecurityConfig
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(modelType.map(value => value.unwrap))(_.modelType)
      .optionallyWith(
        message.map(value => AnyLengthString.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(
        latestFlywheelIteration.map(value =>
          FlywheelIterationId.unwrap(value): java.lang.String
        )
      )(_.latestFlywheelIteration)
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.FlywheelProperties.ReadOnly =
    zio.aws.comprehend.model.FlywheelProperties.wrap(buildAwsValue())
}
object FlywheelProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.FlywheelProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.FlywheelProperties =
      zio.aws.comprehend.model.FlywheelProperties(
        flywheelArn.map(value => value),
        activeModelArn.map(value => value),
        dataAccessRoleArn.map(value => value),
        taskConfig.map(value => value.asEditable),
        dataLakeS3Uri.map(value => value),
        dataSecurityConfig.map(value => value.asEditable),
        status.map(value => value),
        modelType.map(value => value),
        message.map(value => value),
        creationTime.map(value => value),
        lastModifiedTime.map(value => value),
        latestFlywheelIteration.map(value => value)
      )
    def flywheelArn: Optional[ComprehendFlywheelArn]
    def activeModelArn: Optional[ComprehendModelArn]
    def dataAccessRoleArn: Optional[IamRoleArn]
    def taskConfig: Optional[zio.aws.comprehend.model.TaskConfig.ReadOnly]
    def dataLakeS3Uri: Optional[S3Uri]
    def dataSecurityConfig
        : Optional[zio.aws.comprehend.model.DataSecurityConfig.ReadOnly]
    def status: Optional[zio.aws.comprehend.model.FlywheelStatus]
    def modelType: Optional[zio.aws.comprehend.model.ModelType]
    def message: Optional[AnyLengthString]
    def creationTime: Optional[Timestamp]
    def lastModifiedTime: Optional[Timestamp]
    def latestFlywheelIteration: Optional[FlywheelIterationId]
    def getFlywheelArn: ZIO[Any, AwsError, ComprehendFlywheelArn] =
      AwsError.unwrapOptionField("flywheelArn", flywheelArn)
    def getActiveModelArn: ZIO[Any, AwsError, ComprehendModelArn] =
      AwsError.unwrapOptionField("activeModelArn", activeModelArn)
    def getDataAccessRoleArn: ZIO[Any, AwsError, IamRoleArn] =
      AwsError.unwrapOptionField("dataAccessRoleArn", dataAccessRoleArn)
    def getTaskConfig
        : ZIO[Any, AwsError, zio.aws.comprehend.model.TaskConfig.ReadOnly] =
      AwsError.unwrapOptionField("taskConfig", taskConfig)
    def getDataLakeS3Uri: ZIO[Any, AwsError, S3Uri] =
      AwsError.unwrapOptionField("dataLakeS3Uri", dataLakeS3Uri)
    def getDataSecurityConfig: ZIO[
      Any,
      AwsError,
      zio.aws.comprehend.model.DataSecurityConfig.ReadOnly
    ] = AwsError.unwrapOptionField("dataSecurityConfig", dataSecurityConfig)
    def getStatus: ZIO[Any, AwsError, zio.aws.comprehend.model.FlywheelStatus] =
      AwsError.unwrapOptionField("status", status)
    def getModelType: ZIO[Any, AwsError, zio.aws.comprehend.model.ModelType] =
      AwsError.unwrapOptionField("modelType", modelType)
    def getMessage: ZIO[Any, AwsError, AnyLengthString] =
      AwsError.unwrapOptionField("message", message)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getLatestFlywheelIteration: ZIO[Any, AwsError, FlywheelIterationId] =
      AwsError.unwrapOptionField(
        "latestFlywheelIteration",
        latestFlywheelIteration
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.FlywheelProperties
  ) extends zio.aws.comprehend.model.FlywheelProperties.ReadOnly {
    override val flywheelArn: Optional[ComprehendFlywheelArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.flywheelArn())
        .map(value =>
          zio.aws.comprehend.model.primitives.ComprehendFlywheelArn(value)
        )
    override val activeModelArn: Optional[ComprehendModelArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.activeModelArn())
        .map(value =>
          zio.aws.comprehend.model.primitives.ComprehendModelArn(value)
        )
    override val dataAccessRoleArn: Optional[IamRoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.dataAccessRoleArn())
      .map(value => zio.aws.comprehend.model.primitives.IamRoleArn(value))
    override val taskConfig
        : Optional[zio.aws.comprehend.model.TaskConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskConfig())
        .map(value => zio.aws.comprehend.model.TaskConfig.wrap(value))
    override val dataLakeS3Uri: Optional[S3Uri] = zio.aws.core.internal
      .optionalFromNullable(impl.dataLakeS3Uri())
      .map(value => zio.aws.comprehend.model.primitives.S3Uri(value))
    override val dataSecurityConfig
        : Optional[zio.aws.comprehend.model.DataSecurityConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataSecurityConfig())
        .map(value => zio.aws.comprehend.model.DataSecurityConfig.wrap(value))
    override val status: Optional[zio.aws.comprehend.model.FlywheelStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.comprehend.model.FlywheelStatus.wrap(value))
    override val modelType: Optional[zio.aws.comprehend.model.ModelType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modelType())
        .map(value => zio.aws.comprehend.model.ModelType.wrap(value))
    override val message: Optional[AnyLengthString] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => zio.aws.comprehend.model.primitives.AnyLengthString(value))
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.comprehend.model.primitives.Timestamp(value))
    override val lastModifiedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedTime())
      .map(value => zio.aws.comprehend.model.primitives.Timestamp(value))
    override val latestFlywheelIteration: Optional[FlywheelIterationId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.latestFlywheelIteration())
        .map(value =>
          zio.aws.comprehend.model.primitives.FlywheelIterationId(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.FlywheelProperties
  ): zio.aws.comprehend.model.FlywheelProperties.ReadOnly = new Wrapper(impl)
}
