package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BatchDetectDominantLanguageItemResult(
    index: Optional[Integer] = Optional.Absent,
    languages: Optional[Iterable[zio.aws.comprehend.model.DominantLanguage]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.BatchDetectDominantLanguageItemResult = {
    import BatchDetectDominantLanguageItemResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.BatchDetectDominantLanguageItemResult
      .builder()
      .optionallyWith(index.map(value => value: java.lang.Integer))(_.index)
      .optionallyWith(
        languages.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.languages)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.BatchDetectDominantLanguageItemResult.ReadOnly =
    zio.aws.comprehend.model.BatchDetectDominantLanguageItemResult
      .wrap(buildAwsValue())
}
object BatchDetectDominantLanguageItemResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.BatchDetectDominantLanguageItemResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.comprehend.model.BatchDetectDominantLanguageItemResult =
      zio.aws.comprehend.model.BatchDetectDominantLanguageItemResult(
        index.map(value => value),
        languages.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def index: Optional[Integer]
    def languages
        : Optional[List[zio.aws.comprehend.model.DominantLanguage.ReadOnly]]
    def getIndex: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("index", index)
    def getLanguages: ZIO[Any, AwsError, List[
      zio.aws.comprehend.model.DominantLanguage.ReadOnly
    ]] = AwsError.unwrapOptionField("languages", languages)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.BatchDetectDominantLanguageItemResult
  ) extends zio.aws.comprehend.model.BatchDetectDominantLanguageItemResult.ReadOnly {
    override val index: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.index())
      .map(value => value: Integer)
    override val languages
        : Optional[List[zio.aws.comprehend.model.DominantLanguage.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.languages())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.comprehend.model.DominantLanguage.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.BatchDetectDominantLanguageItemResult
  ): zio.aws.comprehend.model.BatchDetectDominantLanguageItemResult.ReadOnly =
    new Wrapper(impl)
}
