package zio.aws.comprehend
import zio.aws.comprehend.model.primitives.SemiStructuredDocumentBlob.Type
import java.time.Instant
import zio.Chunk
import zio.aws.comprehend.model.primitives.{
  SubnetId,
  SecurityGroupId,
  CustomerInputString,
  EventTypeString,
  Integer,
  LabelListItem,
  AttributeNamesListItem,
  TagKey
}
import zio.prelude.Subtype
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object AnyLengthString extends Subtype[String]
    type AnyLengthString =
      zio.aws.comprehend.model.primitives.AnyLengthString.Type
    object AttributeNamesListItem extends Subtype[String]
    type AttributeNamesListItem =
      zio.aws.comprehend.model.primitives.AttributeNamesListItem.Type
    object ClientRequestTokenString extends Subtype[String]
    type ClientRequestTokenString =
      zio.aws.comprehend.model.primitives.ClientRequestTokenString.Type
    object ComprehendArn extends Subtype[String]
    type ComprehendArn = zio.aws.comprehend.model.primitives.ComprehendArn.Type
    object ComprehendArnName extends Subtype[String]
    type ComprehendArnName =
      zio.aws.comprehend.model.primitives.ComprehendArnName.Type
    object ComprehendDatasetArn extends Subtype[String]
    type ComprehendDatasetArn =
      zio.aws.comprehend.model.primitives.ComprehendDatasetArn.Type
    object ComprehendEndpointArn extends Subtype[String]
    type ComprehendEndpointArn =
      zio.aws.comprehend.model.primitives.ComprehendEndpointArn.Type
    object ComprehendEndpointName extends Subtype[String]
    type ComprehendEndpointName =
      zio.aws.comprehend.model.primitives.ComprehendEndpointName.Type
    object ComprehendFlywheelArn extends Subtype[String]
    type ComprehendFlywheelArn =
      zio.aws.comprehend.model.primitives.ComprehendFlywheelArn.Type
    object ComprehendModelArn extends Subtype[String]
    type ComprehendModelArn =
      zio.aws.comprehend.model.primitives.ComprehendModelArn.Type
    object CustomerInputString extends Subtype[String]
    type CustomerInputString =
      zio.aws.comprehend.model.primitives.CustomerInputString.Type
    object Description extends Subtype[String]
    type Description = zio.aws.comprehend.model.primitives.Description.Type
    object DocumentClassifierArn extends Subtype[String]
    type DocumentClassifierArn =
      zio.aws.comprehend.model.primitives.DocumentClassifierArn.Type
    object DocumentClassifierEndpointArn extends Subtype[String]
    type DocumentClassifierEndpointArn =
      zio.aws.comprehend.model.primitives.DocumentClassifierEndpointArn.Type
    object EntityRecognizerArn extends Subtype[String]
    type EntityRecognizerArn =
      zio.aws.comprehend.model.primitives.EntityRecognizerArn.Type
    object EntityRecognizerEndpointArn extends Subtype[String]
    type EntityRecognizerEndpointArn =
      zio.aws.comprehend.model.primitives.EntityRecognizerEndpointArn.Type
    object EntityTypeName extends Subtype[String]
    type EntityTypeName =
      zio.aws.comprehend.model.primitives.EntityTypeName.Type
    object EventTypeString extends Subtype[String]
    type EventTypeString =
      zio.aws.comprehend.model.primitives.EventTypeString.Type
    object FlywheelIterationId extends Subtype[String]
    type FlywheelIterationId =
      zio.aws.comprehend.model.primitives.FlywheelIterationId.Type
    object FlywheelS3Uri extends Subtype[String]
    type FlywheelS3Uri = zio.aws.comprehend.model.primitives.FlywheelS3Uri.Type
    object IamRoleArn extends Subtype[String]
    type IamRoleArn = zio.aws.comprehend.model.primitives.IamRoleArn.Type
    object InferenceUnitsInteger extends Subtype[Int]
    type InferenceUnitsInteger =
      zio.aws.comprehend.model.primitives.InferenceUnitsInteger.Type
    type Integer = Int
    object JobId extends Subtype[String]
    type JobId = zio.aws.comprehend.model.primitives.JobId.Type
    object JobName extends Subtype[String]
    type JobName = zio.aws.comprehend.model.primitives.JobName.Type
    object KmsKeyId extends Subtype[String]
    type KmsKeyId = zio.aws.comprehend.model.primitives.KmsKeyId.Type
    object LabelDelimiter extends Subtype[String]
    type LabelDelimiter =
      zio.aws.comprehend.model.primitives.LabelDelimiter.Type
    object LabelListItem extends Subtype[String]
    type LabelListItem = zio.aws.comprehend.model.primitives.LabelListItem.Type
    object MaskCharacter extends Subtype[String]
    type MaskCharacter = zio.aws.comprehend.model.primitives.MaskCharacter.Type
    object MaxResultsInteger extends Subtype[Int]
    type MaxResultsInteger =
      zio.aws.comprehend.model.primitives.MaxResultsInteger.Type
    object NumberOfDocuments extends Subtype[Long]
    type NumberOfDocuments =
      zio.aws.comprehend.model.primitives.NumberOfDocuments.Type
    object NumberOfTopicsInteger extends Subtype[Int]
    type NumberOfTopicsInteger =
      zio.aws.comprehend.model.primitives.NumberOfTopicsInteger.Type
    object Policy extends Subtype[String]
    type Policy = zio.aws.comprehend.model.primitives.Policy.Type
    object PolicyRevisionId extends Subtype[String]
    type PolicyRevisionId =
      zio.aws.comprehend.model.primitives.PolicyRevisionId.Type
    object S3Uri extends Subtype[String]
    type S3Uri = zio.aws.comprehend.model.primitives.S3Uri.Type
    object SecurityGroupId extends Subtype[String]
    type SecurityGroupId =
      zio.aws.comprehend.model.primitives.SecurityGroupId.Type
    object SemiStructuredDocumentBlob extends Subtype[Chunk[Byte]]
    type SemiStructuredDocumentBlob =
      zio.aws.comprehend.model.primitives.SemiStructuredDocumentBlob.Type
    object SubnetId extends Subtype[String]
    type SubnetId = zio.aws.comprehend.model.primitives.SubnetId.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.comprehend.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.comprehend.model.primitives.TagValue.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.comprehend.model.primitives.Timestamp.Type
    object VersionName extends Subtype[String]
    type VersionName = zio.aws.comprehend.model.primitives.VersionName.Type
  }
  type AttributeNamesList = List[AttributeNamesListItem]
  type BatchItemErrorList = List[zio.aws.comprehend.model.BatchItemError]
  type CustomerInputStringList = List[CustomerInputString]
  type DatasetAugmentedManifestsList =
    List[zio.aws.comprehend.model.DatasetAugmentedManifestsListItem]
  type DatasetPropertiesList = List[zio.aws.comprehend.model.DatasetProperties]
  type DocumentClassificationJobPropertiesList =
    List[zio.aws.comprehend.model.DocumentClassificationJobProperties]
  type DocumentClassifierAugmentedManifestsList =
    List[zio.aws.comprehend.model.AugmentedManifestsListItem]
  type DocumentClassifierPropertiesList =
    List[zio.aws.comprehend.model.DocumentClassifierProperties]
  type DocumentClassifierSummariesList =
    List[zio.aws.comprehend.model.DocumentClassifierSummary]
  type DominantLanguageDetectionJobPropertiesList =
    List[zio.aws.comprehend.model.DominantLanguageDetectionJobProperties]
  type EndpointPropertiesList =
    List[zio.aws.comprehend.model.EndpointProperties]
  type EntitiesDetectionJobPropertiesList =
    List[zio.aws.comprehend.model.EntitiesDetectionJobProperties]
  type EntityRecognizerAugmentedManifestsList =
    List[zio.aws.comprehend.model.AugmentedManifestsListItem]
  type EntityRecognizerMetadataEntityTypesList =
    List[zio.aws.comprehend.model.EntityRecognizerMetadataEntityTypesListItem]
  type EntityRecognizerPropertiesList =
    List[zio.aws.comprehend.model.EntityRecognizerProperties]
  type EntityRecognizerSummariesList =
    List[zio.aws.comprehend.model.EntityRecognizerSummary]
  type EntityTypesList = List[zio.aws.comprehend.model.EntityTypesListItem]
  type EventsDetectionJobPropertiesList =
    List[zio.aws.comprehend.model.EventsDetectionJobProperties]
  type FlywheelIterationPropertiesList =
    List[zio.aws.comprehend.model.FlywheelIterationProperties]
  type FlywheelSummaryList = List[zio.aws.comprehend.model.FlywheelSummary]
  type KeyPhrasesDetectionJobPropertiesList =
    List[zio.aws.comprehend.model.KeyPhrasesDetectionJobProperties]
  type LabelsList = List[LabelListItem]
  type ListOfBlockReferences = List[zio.aws.comprehend.model.BlockReference]
  type ListOfBlocks = List[zio.aws.comprehend.model.Block]
  type ListOfChildBlocks = List[zio.aws.comprehend.model.ChildBlock]
  type ListOfClasses = List[zio.aws.comprehend.model.DocumentClass]
  type ListOfDescriptiveMentionIndices = List[Integer]
  type ListOfDetectDominantLanguageResult =
    List[zio.aws.comprehend.model.BatchDetectDominantLanguageItemResult]
  type ListOfDetectEntitiesResult =
    List[zio.aws.comprehend.model.BatchDetectEntitiesItemResult]
  type ListOfDetectKeyPhrasesResult =
    List[zio.aws.comprehend.model.BatchDetectKeyPhrasesItemResult]
  type ListOfDetectSentimentResult =
    List[zio.aws.comprehend.model.BatchDetectSentimentItemResult]
  type ListOfDetectSyntaxResult =
    List[zio.aws.comprehend.model.BatchDetectSyntaxItemResult]
  type ListOfDetectTargetedSentimentResult =
    List[zio.aws.comprehend.model.BatchDetectTargetedSentimentItemResult]
  type ListOfDocumentReadFeatureTypes =
    List[zio.aws.comprehend.model.DocumentReadFeatureTypes]
  type ListOfDocumentType = List[zio.aws.comprehend.model.DocumentTypeListItem]
  type ListOfDominantLanguages = List[zio.aws.comprehend.model.DominantLanguage]
  type ListOfEntities = List[zio.aws.comprehend.model.Entity]
  type ListOfEntityLabels = List[zio.aws.comprehend.model.EntityLabel]
  type ListOfErrors = List[zio.aws.comprehend.model.ErrorsListItem]
  type ListOfExtractedCharacters =
    List[zio.aws.comprehend.model.ExtractedCharactersListItem]
  type ListOfKeyPhrases = List[zio.aws.comprehend.model.KeyPhrase]
  type ListOfLabels = List[zio.aws.comprehend.model.DocumentLabel]
  type ListOfMentions = List[zio.aws.comprehend.model.TargetedSentimentMention]
  type ListOfPiiEntities = List[zio.aws.comprehend.model.PiiEntity]
  type ListOfPiiEntityTypes = List[zio.aws.comprehend.model.PiiEntityType]
  type ListOfRelationships =
    List[zio.aws.comprehend.model.RelationshipsListItem]
  type ListOfSyntaxTokens = List[zio.aws.comprehend.model.SyntaxToken]
  type ListOfTargetedSentimentEntities =
    List[zio.aws.comprehend.model.TargetedSentimentEntity]
  type PiiEntitiesDetectionJobPropertiesList =
    List[zio.aws.comprehend.model.PiiEntitiesDetectionJobProperties]
  type Polygon = List[zio.aws.comprehend.model.Point]
  type SecurityGroupIds = List[SecurityGroupId]
  type SentimentDetectionJobPropertiesList =
    List[zio.aws.comprehend.model.SentimentDetectionJobProperties]
  type StringList = List[String]
  type Subnets = List[SubnetId]
  type TagKeyList = List[TagKey]
  type TagList = List[zio.aws.comprehend.model.Tag]
  type TargetEventTypes = List[EventTypeString]
  type TargetedSentimentDetectionJobPropertiesList =
    List[zio.aws.comprehend.model.TargetedSentimentDetectionJobProperties]
  type TopicsDetectionJobPropertiesList =
    List[zio.aws.comprehend.model.TopicsDetectionJobProperties]
}
