package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Block(
    id: Optional[String] = Optional.Absent,
    blockType: Optional[zio.aws.comprehend.model.BlockType] = Optional.Absent,
    text: Optional[String] = Optional.Absent,
    page: Optional[Integer] = Optional.Absent,
    geometry: Optional[zio.aws.comprehend.model.Geometry] = Optional.Absent,
    relationships: Optional[
      Iterable[zio.aws.comprehend.model.RelationshipsListItem]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.Block = {
    import Block.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.Block
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(blockType.map(value => value.unwrap))(_.blockType)
      .optionallyWith(text.map(value => value: java.lang.String))(_.text)
      .optionallyWith(page.map(value => value: java.lang.Integer))(_.page)
      .optionallyWith(geometry.map(value => value.buildAwsValue()))(_.geometry)
      .optionallyWith(
        relationships.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.relationships)
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.Block.ReadOnly =
    zio.aws.comprehend.model.Block.wrap(buildAwsValue())
}
object Block {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.comprehend.model.Block] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.Block =
      zio.aws.comprehend.model.Block(
        id.map(value => value),
        blockType.map(value => value),
        text.map(value => value),
        page.map(value => value),
        geometry.map(value => value.asEditable),
        relationships.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def id: Optional[String]
    def blockType: Optional[zio.aws.comprehend.model.BlockType]
    def text: Optional[String]
    def page: Optional[Integer]
    def geometry: Optional[zio.aws.comprehend.model.Geometry.ReadOnly]
    def relationships: Optional[
      List[zio.aws.comprehend.model.RelationshipsListItem.ReadOnly]
    ]
    def getId: ZIO[Any, AwsError, String] = AwsError.unwrapOptionField("id", id)
    def getBlockType: ZIO[Any, AwsError, zio.aws.comprehend.model.BlockType] =
      AwsError.unwrapOptionField("blockType", blockType)
    def getText: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("text", text)
    def getPage: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("page", page)
    def getGeometry
        : ZIO[Any, AwsError, zio.aws.comprehend.model.Geometry.ReadOnly] =
      AwsError.unwrapOptionField("geometry", geometry)
    def getRelationships: ZIO[Any, AwsError, List[
      zio.aws.comprehend.model.RelationshipsListItem.ReadOnly
    ]] = AwsError.unwrapOptionField("relationships", relationships)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.Block
  ) extends zio.aws.comprehend.model.Block.ReadOnly {
    override val id: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => value: String)
    override val blockType: Optional[zio.aws.comprehend.model.BlockType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.blockType())
        .map(value => zio.aws.comprehend.model.BlockType.wrap(value))
    override val text: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.text())
      .map(value => value: String)
    override val page: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.page())
      .map(value => value: Integer)
    override val geometry
        : Optional[zio.aws.comprehend.model.Geometry.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.geometry())
        .map(value => zio.aws.comprehend.model.Geometry.wrap(value))
    override val relationships: Optional[
      List[zio.aws.comprehend.model.RelationshipsListItem.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.relationships())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.comprehend.model.RelationshipsListItem.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.Block
  ): zio.aws.comprehend.model.Block.ReadOnly = new Wrapper(impl)
}
