package zio.aws.comprehend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeFlywheelIterationResponse(
    flywheelIterationProperties: Optional[
      zio.aws.comprehend.model.FlywheelIterationProperties
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.DescribeFlywheelIterationResponse = {
    import DescribeFlywheelIterationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.DescribeFlywheelIterationResponse
      .builder()
      .optionallyWith(
        flywheelIterationProperties.map(value => value.buildAwsValue())
      )(_.flywheelIterationProperties)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.DescribeFlywheelIterationResponse.ReadOnly =
    zio.aws.comprehend.model.DescribeFlywheelIterationResponse
      .wrap(buildAwsValue())
}
object DescribeFlywheelIterationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.DescribeFlywheelIterationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.DescribeFlywheelIterationResponse =
      zio.aws.comprehend.model.DescribeFlywheelIterationResponse(
        flywheelIterationProperties.map(value => value.asEditable)
      )
    def flywheelIterationProperties: Optional[
      zio.aws.comprehend.model.FlywheelIterationProperties.ReadOnly
    ]
    def getFlywheelIterationProperties: ZIO[
      Any,
      AwsError,
      zio.aws.comprehend.model.FlywheelIterationProperties.ReadOnly
    ] = AwsError.unwrapOptionField(
      "flywheelIterationProperties",
      flywheelIterationProperties
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.DescribeFlywheelIterationResponse
  ) extends zio.aws.comprehend.model.DescribeFlywheelIterationResponse.ReadOnly {
    override val flywheelIterationProperties: Optional[
      zio.aws.comprehend.model.FlywheelIterationProperties.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.flywheelIterationProperties())
      .map(value =>
        zio.aws.comprehend.model.FlywheelIterationProperties.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.DescribeFlywheelIterationResponse
  ): zio.aws.comprehend.model.DescribeFlywheelIterationResponse.ReadOnly =
    new Wrapper(impl)
}
