package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.ComprehendDatasetArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateDatasetResponse(
    datasetArn: Optional[ComprehendDatasetArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.CreateDatasetResponse = {
    import CreateDatasetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.CreateDatasetResponse
      .builder()
      .optionallyWith(
        datasetArn.map(value =>
          ComprehendDatasetArn.unwrap(value): java.lang.String
        )
      )(_.datasetArn)
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.CreateDatasetResponse.ReadOnly =
    zio.aws.comprehend.model.CreateDatasetResponse.wrap(buildAwsValue())
}
object CreateDatasetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.CreateDatasetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.CreateDatasetResponse =
      zio.aws.comprehend.model
        .CreateDatasetResponse(datasetArn.map(value => value))
    def datasetArn: Optional[ComprehendDatasetArn]
    def getDatasetArn: ZIO[Any, AwsError, ComprehendDatasetArn] =
      AwsError.unwrapOptionField("datasetArn", datasetArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.CreateDatasetResponse
  ) extends zio.aws.comprehend.model.CreateDatasetResponse.ReadOnly {
    override val datasetArn: Optional[ComprehendDatasetArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.datasetArn())
        .map(value =>
          zio.aws.comprehend.model.primitives.ComprehendDatasetArn(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.CreateDatasetResponse
  ): zio.aws.comprehend.model.CreateDatasetResponse.ReadOnly = new Wrapper(impl)
}
