package zio.aws.comprehend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class TaskConfig(
    languageCode: zio.aws.comprehend.model.LanguageCode,
    documentClassificationConfig: Optional[
      zio.aws.comprehend.model.DocumentClassificationConfig
    ] = Optional.Absent,
    entityRecognitionConfig: Optional[
      zio.aws.comprehend.model.EntityRecognitionConfig
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.TaskConfig = {
    import TaskConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.TaskConfig
      .builder()
      .languageCode(languageCode.unwrap)
      .optionallyWith(
        documentClassificationConfig.map(value => value.buildAwsValue())
      )(_.documentClassificationConfig)
      .optionallyWith(
        entityRecognitionConfig.map(value => value.buildAwsValue())
      )(_.entityRecognitionConfig)
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.TaskConfig.ReadOnly =
    zio.aws.comprehend.model.TaskConfig.wrap(buildAwsValue())
}
object TaskConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.TaskConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.TaskConfig =
      zio.aws.comprehend.model.TaskConfig(
        languageCode,
        documentClassificationConfig.map(value => value.asEditable),
        entityRecognitionConfig.map(value => value.asEditable)
      )
    def languageCode: zio.aws.comprehend.model.LanguageCode
    def documentClassificationConfig: Optional[
      zio.aws.comprehend.model.DocumentClassificationConfig.ReadOnly
    ]
    def entityRecognitionConfig
        : Optional[zio.aws.comprehend.model.EntityRecognitionConfig.ReadOnly]
    def getLanguageCode
        : ZIO[Any, Nothing, zio.aws.comprehend.model.LanguageCode] =
      ZIO.succeed(languageCode)
    def getDocumentClassificationConfig: ZIO[
      Any,
      AwsError,
      zio.aws.comprehend.model.DocumentClassificationConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "documentClassificationConfig",
      documentClassificationConfig
    )
    def getEntityRecognitionConfig: ZIO[
      Any,
      AwsError,
      zio.aws.comprehend.model.EntityRecognitionConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "entityRecognitionConfig",
      entityRecognitionConfig
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.TaskConfig
  ) extends zio.aws.comprehend.model.TaskConfig.ReadOnly {
    override val languageCode: zio.aws.comprehend.model.LanguageCode =
      zio.aws.comprehend.model.LanguageCode.wrap(impl.languageCode())
    override val documentClassificationConfig: Optional[
      zio.aws.comprehend.model.DocumentClassificationConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.documentClassificationConfig())
      .map(value =>
        zio.aws.comprehend.model.DocumentClassificationConfig.wrap(value)
      )
    override val entityRecognitionConfig
        : Optional[zio.aws.comprehend.model.EntityRecognitionConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.entityRecognitionConfig())
        .map(value =>
          zio.aws.comprehend.model.EntityRecognitionConfig.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.TaskConfig
  ): zio.aws.comprehend.model.TaskConfig.ReadOnly = new Wrapper(impl)
}
